/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.tag.PaperTagListenerManager;
import io.papermc.paper.tag.TagEventConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ElementLookup<T> elementLookup;
    private final String directory;

    public TagLoader(ElementLookup<T> entrySupplier, String dataType) {
        this.elementLookup = entrySupplier;
        this.directory = dataType;
    }

    public Map<ResourceLocation, List<EntryWithSource>> load(ResourceManager resourceManager) {
        HashMap<ResourceLocation, List<EntryWithSource>> map = new HashMap<ResourceLocation, List<EntryWithSource>>();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json(this.directory);
        for (Map.Entry<ResourceLocation, List<Resource>> entry : fileToIdConverter.listMatchingResourceStacks(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourceLocation2, id -> new ArrayList());
                        TagFile tagFile = (TagFile)TagFile.CODEC.parse(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)).getOrThrow();
                        if (tagFile.replace()) {
                            list.clear();
                        }
                        String string = resource.sourcePackId();
                        tagFile.entries().forEach(entryx -> list.add(new EntryWithSource((TagEntry)entryx, string)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception var17) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourceLocation2, resourceLocation, resource.sourcePackId(), var17});
                }
            }
        }
        return map;
    }

    private Either<List<EntryWithSource>, List<T>> tryBuildTag(TagEntry.Lookup<T> valueGetter, List<EntryWithSource> entries) {
        LinkedHashSet sequencedSet = new LinkedHashSet();
        ArrayList<EntryWithSource> list = new ArrayList<EntryWithSource>();
        for (EntryWithSource entryWithSource : entries) {
            if (entryWithSource.entry().build(valueGetter, sequencedSet::add)) continue;
            list.add(entryWithSource);
        }
        return list.isEmpty() ? Either.right(List.copyOf(sequencedSet)) : Either.left(list);
    }

    public Map<ResourceLocation, List<T>> build(Map<ResourceLocation, List<EntryWithSource>> tags, @Nullable TagEventConfig<T, ?> eventConfig) {
        tags = PaperTagListenerManager.INSTANCE.firePreFlattenEvent(tags, eventConfig);
        final HashMap map = new HashMap();
        TagEntry.Lookup lookup = new TagEntry.Lookup<T>(){

            @Override
            @Nullable
            public T element(ResourceLocation id, boolean required) {
                return TagLoader.this.elementLookup.get(id, required).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> tag(ResourceLocation id) {
                return (Collection)map.get(id);
            }
        };
        DependencySorter<ResourceLocation, SortingEntry> dependencySorter = new DependencySorter<ResourceLocation, SortingEntry>();
        tags.forEach((id, entries) -> dependencySorter.addEntry((ResourceLocation)id, new SortingEntry((List<EntryWithSource>)entries)));
        dependencySorter.orderByDependencies((id, dependencies) -> this.tryBuildTag(lookup, dependencies.entries).ifLeft(missingReferences -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", id, (Object)missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(values -> map.put((ResourceLocation)id, values)));
        return PaperTagListenerManager.INSTANCE.firePostFlattenEvent(map, eventConfig);
    }

    public static <T> void loadTagsFromNetwork(TagNetworkSerialization.NetworkPayload tags, WritableRegistry<T> registry) {
        tags.resolve(registry).tags.forEach(registry::bindTag);
    }

    public static List<Registry.PendingTags<?>> loadTagsForExistingRegistries(ResourceManager resourceManager, RegistryAccess registryManager) {
        return TagLoader.loadTagsForExistingRegistries(resourceManager, registryManager, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static List<Registry.PendingTags<?>> loadTagsForExistingRegistries(ResourceManager resourceManager, RegistryAccess registryManager, ReloadableRegistrarEvent.Cause cause) {
        return registryManager.registries().map(registry -> TagLoader.loadPendingTags(resourceManager, registry.value(), cause)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static <T> void loadTagsForRegistry(ResourceManager resourceManager, WritableRegistry<T> registry) {
        TagLoader.loadTagsForRegistry(resourceManager, registry, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static <T> void loadTagsForRegistry(ResourceManager resourceManager, WritableRegistry<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey resourceKey = registry.key();
        TagLoader<Holder<Holder<T>>> tagLoader = new TagLoader<Holder<Holder<T>>>(ElementLookup.fromWritableRegistry(registry), Registries.tagsDirPath(resourceKey));
        tagLoader.build(tagLoader.load(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause)).forEach((id, entries) -> registry.bindTag(TagKey.create(resourceKey, id), (List)entries));
    }

    private static <T> Map<TagKey<T>, List<Holder<T>>> wrapTags(ResourceKey<? extends Registry<T>> registryRef, Map<ResourceLocation, List<Holder<T>>> tags) {
        return tags.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.create(registryRef, (ResourceLocation)entry.getKey()), Map.Entry::getValue));
    }

    private static <T> Optional<Registry.PendingTags<T>> loadPendingTags(ResourceManager resourceManager, Registry<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey<Registry<T>> resourceKey = registry.key();
        TagLoader<Holder<Holder<T>>> tagLoader = new TagLoader<Holder<Holder<T>>>(ElementLookup.fromFrozenRegistry(registry), Registries.tagsDirPath(resourceKey));
        LoadResult<T> loadResult = new LoadResult<T>(resourceKey, TagLoader.wrapTags(registry.key(), tagLoader.build(tagLoader.load(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause))));
        return loadResult.tags().isEmpty() ? Optional.empty() : Optional.of(registry.prepareTagReload(loadResult));
    }

    public static List<HolderLookup.RegistryLookup<?>> buildUpdatedLookups(RegistryAccess.Frozen registryManager, List<Registry.PendingTags<?>> tagLoads) {
        ArrayList list = new ArrayList();
        registryManager.registries().forEach(registry -> {
            Registry.PendingTags pendingTags = TagLoader.findTagsForRegistry(tagLoads, registry.key());
            list.add(pendingTags != null ? pendingTags.lookup() : registry.value());
        });
        return list;
    }

    @Nullable
    private static Registry.PendingTags<?> findTagsForRegistry(List<Registry.PendingTags<?>> pendingTags, ResourceKey<? extends Registry<?>> registryRef) {
        for (Registry.PendingTags<?> pendingTags2 : pendingTags) {
            if (pendingTags2.key() != registryRef) continue;
            return pendingTags2;
        }
        return null;
    }

    public static interface ElementLookup<T> {
        public Optional<? extends T> get(ResourceLocation var1, boolean var2);

        public static <T> ElementLookup<? extends Holder<T>> fromFrozenRegistry(Registry<T> registry) {
            return (id, required) -> registry.get(id);
        }

        public static <T> ElementLookup<Holder<T>> fromWritableRegistry(WritableRegistry<T> registry) {
            HolderGetter holderGetter = registry.createRegistrationLookup();
            return (id, required) -> (required ? holderGetter : registry).get(ResourceKey.create(registry.key(), id));
        }
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<TagKey<T>, List<Holder<T>>> tags) {
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<ResourceLocation>
    {
        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> callback) {
            this.entries.forEach(entry -> entry.entry.visitRequiredDependencies(callback));
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> callback) {
            this.entries.forEach(entry -> entry.entry.visitOptionalDependencies(callback));
        }
    }
}

