/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ARGB {
    public static int alpha(int argb) {
        return argb >>> 24;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(int red, int green, int blue) {
        return ARGB.color(255, red, green, blue);
    }

    public static int color(Vec3 rgb) {
        return ARGB.color(ARGB.as8BitChannel((float)rgb.x()), ARGB.as8BitChannel((float)rgb.y()), ARGB.as8BitChannel((float)rgb.z()));
    }

    public static int multiply(int first, int second) {
        if (first == -1) {
            return second;
        }
        if (second == -1) {
            return first;
        }
        return ARGB.color(ARGB.alpha(first) * ARGB.alpha(second) / 255, ARGB.red(first) * ARGB.red(second) / 255, ARGB.green(first) * ARGB.green(second) / 255, ARGB.blue(first) * ARGB.blue(second) / 255);
    }

    public static int scaleRGB(int argb, float scale) {
        return ARGB.scaleRGB(argb, scale, scale, scale);
    }

    public static int scaleRGB(int argb, float redScale, float greenScale, float blueScale) {
        return ARGB.color(ARGB.alpha(argb), Math.clamp((long)((int)((float)ARGB.red(argb) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(argb) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(argb) * blueScale)), 0, 255));
    }

    public static int scaleRGB(int argb, int scale) {
        return ARGB.color(ARGB.alpha(argb), Math.clamp((long)ARGB.red(argb) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.green(argb) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.blue(argb) * (long)scale / 255L, 0, 255));
    }

    public static int greyscale(int argb) {
        int i = (int)((float)ARGB.red(argb) * 0.3f + (float)ARGB.green(argb) * 0.59f + (float)ARGB.blue(argb) * 0.11f);
        return ARGB.color(i, i, i);
    }

    public static int lerp(float delta, int start, int end) {
        int i = Mth.lerpInt(delta, ARGB.alpha(start), ARGB.alpha(end));
        int j = Mth.lerpInt(delta, ARGB.red(start), ARGB.red(end));
        int k = Mth.lerpInt(delta, ARGB.green(start), ARGB.green(end));
        int l = Mth.lerpInt(delta, ARGB.blue(start), ARGB.blue(end));
        return ARGB.color(i, j, k, l);
    }

    public static int opaque(int argb) {
        return argb | 0xFF000000;
    }

    public static int transparent(int argb) {
        return argb & 0xFFFFFF;
    }

    public static int color(int alpha, int rgb) {
        return alpha << 24 | rgb & 0xFFFFFF;
    }

    public static int white(float alpha) {
        return ARGB.as8BitChannel(alpha) << 24 | 0xFFFFFF;
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return ARGB.color(ARGB.as8BitChannel(alpha), ARGB.as8BitChannel(red), ARGB.as8BitChannel(green), ARGB.as8BitChannel(blue));
    }

    public static Vector3f vector3fFromRGB24(int rgb) {
        float f = (float)ARGB.red(rgb) / 255.0f;
        float g = (float)ARGB.green(rgb) / 255.0f;
        float h = (float)ARGB.blue(rgb) / 255.0f;
        return new Vector3f(f, g, h);
    }

    public static int average(int first, int second) {
        return ARGB.color((ARGB.alpha(first) + ARGB.alpha(second)) / 2, (ARGB.red(first) + ARGB.red(second)) / 2, (ARGB.green(first) + ARGB.green(second)) / 2, (ARGB.blue(first) + ARGB.blue(second)) / 2);
    }

    public static int as8BitChannel(float value) {
        return Mth.floor(value * 255.0f);
    }

    public static float from8BitChannel(int channel) {
        return (float)channel / 255.0f;
    }

    public static int toABGR(int argb) {
        return argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
    }

    public static int fromABGR(int abgr) {
        return ARGB.toABGR(abgr);
    }
}

