/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;

public interface StringRepresentable {
    public static final int PRE_BUILT_MAP_THRESHOLD = 16;

    public String getSerializedName();

    public static <E extends Enum<E>> EnumCodec<E> fromEnum(Supplier<E[]> enumValues) {
        return StringRepresentable.fromEnumWithMapping(enumValues, id -> id);
    }

    public static <E extends Enum<E>> EnumCodec<E> fromEnumWithMapping(Supplier<E[]> enumValues, Function<String, String> valueNameTransformer) {
        Enum[] enums = (Enum[])enumValues.get();
        Function function = StringRepresentable.createNameLookup((StringRepresentable[])enums, valueNameTransformer);
        return new EnumCodec(enums, function);
    }

    public static <T extends StringRepresentable> Codec<T> fromValues(Supplier<T[]> values) {
        StringRepresentable[] stringRepresentables = (StringRepresentable[])values.get();
        Function function = StringRepresentable.createNameLookup((StringRepresentable[])stringRepresentables, (T valueName) -> valueName);
        ToIntFunction<StringRepresentable> toIntFunction = Util.createIndexLookup(Arrays.asList(stringRepresentables));
        return new StringRepresentableCodec(stringRepresentables, function, toIntFunction);
    }

    public static <T extends StringRepresentable> Function<String, T> createNameLookup(T[] values, Function<String, String> valueNameTransformer) {
        if (values.length > 16) {
            Map<String, StringRepresentable> map = Arrays.stream(values).collect(Collectors.toMap(value -> (String)valueNameTransformer.apply(value.getSerializedName()), value -> value));
            return name -> name == null ? null : (StringRepresentable)map.get(name);
        }
        return name -> {
            for (StringRepresentable stringRepresentable : values) {
                if (!((String)valueNameTransformer.apply(stringRepresentable.getSerializedName())).equals(name)) continue;
                return stringRepresentable;
            }
            return null;
        };
    }

    public static Keyable keys(final StringRepresentable[] values) {
        return new Keyable(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return Arrays.stream(values).map(StringRepresentable::getSerializedName).map(arg_0 -> dynamicOps.createString(arg_0));
            }
        };
    }

    @Deprecated
    public static class EnumCodec<E extends Enum<E>>
    extends StringRepresentableCodec<E> {
        private final Function<String, E> resolver;

        public EnumCodec(E[] values, Function<String, E> idToIdentifiable) {
            super(values, idToIdentifiable, enum_ -> ((Enum)enum_).ordinal());
            this.resolver = idToIdentifiable;
        }

        @Nullable
        public E byName(@Nullable String id) {
            return (E)((Enum)this.resolver.apply(id));
        }

        public E byName(@Nullable String id, E fallback) {
            return (E)((Enum)Objects.requireNonNullElse(this.byName(id), fallback));
        }

        public E byName(@Nullable String id, Supplier<? extends E> fallbackSupplier) {
            return (E)((Enum)Objects.requireNonNullElseGet(this.byName(id), fallbackSupplier));
        }
    }

    public static class StringRepresentableCodec<S extends StringRepresentable>
    implements Codec<S> {
        private final Codec<S> codec;

        public StringRepresentableCodec(S[] values, Function<String, S> idToIdentifiable, ToIntFunction<S> identifiableToOrdinal) {
            this.codec = ExtraCodecs.orCompressed(Codec.stringResolver(StringRepresentable::getSerializedName, idToIdentifiable), ExtraCodecs.idResolverCodec(identifiableToOrdinal, ordinal -> ordinal >= 0 && ordinal < values.length ? values[ordinal] : null, -1));
        }

        public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> dynamicOps, T object) {
            return this.codec.decode(dynamicOps, object);
        }

        public <T> DataResult<T> encode(S stringRepresentable, DynamicOps<T> dynamicOps, T object) {
            return this.codec.encode(stringRepresentable, dynamicOps, object);
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((S)((StringRepresentable)object), (DynamicOps<T>)dynamicOps, (T)object2);
        }
    }
}

