/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import org.jetbrains.annotations.Contract;

public class ContextMap {
    private final Map<ContextKey<?>, Object> params;

    ContextMap(Map<ContextKey<?>, Object> map) {
        this.params = map;
    }

    public boolean has(ContextKey<?> parameter) {
        return this.params.containsKey(parameter);
    }

    public <T> T getOrThrow(ContextKey<T> parameter) {
        Object object = this.params.get(parameter);
        if (object == null) {
            throw new NoSuchElementException(parameter.name().toString());
        }
        return (T)object;
    }

    @Nullable
    public <T> T getOptional(ContextKey<T> parameter) {
        return (T)this.params.get(parameter);
    }

    @Nullable
    @Contract(value="_,!null->!null; _,_->_")
    public <T> T getOrDefault(ContextKey<T> parameter, @Nullable T defaultValue) {
        return (T)this.params.getOrDefault(parameter, defaultValue);
    }

    public static class Builder {
        private final Map<ContextKey<?>, Object> params = new IdentityHashMap();

        public <T> Builder withParameter(ContextKey<T> parameter, T value) {
            this.params.put(parameter, value);
            return this;
        }

        public <T> Builder withOptionalParameter(ContextKey<T> parameter, @Nullable T value) {
            if (value == null) {
                this.params.remove(parameter);
            } else {
                this.params.put(parameter, value);
            }
            return this;
        }

        public <T> T getParameter(ContextKey<T> parameter) {
            Object object = this.params.get(parameter);
            if (object == null) {
                throw new NoSuchElementException(parameter.name().toString());
            }
            return (T)object;
        }

        @Nullable
        public <T> T getOptionalParameter(ContextKey<T> parameter) {
            return (T)this.params.get(parameter);
        }

        public ContextMap create(ContextKeySet type) {
            Sets.SetView set = Sets.difference(this.params.keySet(), type.allowed());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf(set));
            }
            Sets.SetView set2 = Sets.difference(type.required(), this.params.keySet());
            if (!set2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(set2));
            }
            return new ContextMap(this.params);
        }
    }
}

