/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public class ExtraDataFixUtils {
    public static Dynamic<?> fixBlockPos(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("X").asNumber().result();
        Optional optional2 = dynamic.get("Y").asNumber().result();
        Optional optional3 = dynamic.get("Z").asNumber().result();
        if (optional.isEmpty() || optional2.isEmpty() || optional3.isEmpty()) {
            return dynamic;
        }
        return dynamic.createIntList(IntStream.of(((Number)optional.get()).intValue(), ((Number)optional2.get()).intValue(), ((Number)optional3.get()).intValue()));
    }

    public static <T, R> Typed<R> cast(Type<R> type, Typed<T> typed) {
        return new Typed(type, typed.getOps(), typed.getValue());
    }

    public static Type<?> patchSubType(Type<?> type, Type<?> oldType, Type<?> newType) {
        return type.all(ExtraDataFixUtils.typePatcher(oldType, newType), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> oldType, Type<B> newType) {
        RewriteResult rewriteResult = RewriteResult.create((View)View.create((String)"Patcher", oldType, newType, dynamicOps -> object -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(oldType, (RewriteResult)rewriteResult), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> chainAllFilters(Function<Typed<?>, Typed<?>> ... fixes) {
        return typed -> {
            for (Function function : fixes) {
                typed = (Typed)function.apply(typed);
            }
            return typed;
        };
    }

    public static Dynamic<?> blockState(String id, Map<String, String> properties) {
        Dynamic<CompoundTag> dynamic = new Dynamic<CompoundTag>(NbtOps.INSTANCE, new CompoundTag());
        Dynamic<CompoundTag> dynamic2 = dynamic.set("Name", dynamic.createString(id));
        if (!properties.isEmpty()) {
            dynamic2 = dynamic2.set("Properties", dynamic.createMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> dynamic.createString((String)entry.getKey()), entry -> dynamic.createString((String)entry.getValue())))));
        }
        return dynamic2;
    }

    public static Dynamic<?> blockState(String id) {
        return ExtraDataFixUtils.blockState(id, Map.of());
    }

    public static Dynamic<?> fixStringField(Dynamic<?> dynamic, String fieldName, UnaryOperator<String> applier) {
        return dynamic.update(fieldName, value -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)value.asString().map((Function)applier).map(arg_0 -> ((Dynamic)dynamic).createString(arg_0)).result(), (Object)value))));
    }
}

