/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.ItemStackComponentRemainderFix;

public class LockComponentPredicateFix
extends ItemStackComponentRemainderFix {
    public static final Escaper ESCAPER = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();

    public LockComponentPredicateFix(Schema outputSchema) {
        super(outputSchema, "LockComponentPredicateFix", "minecraft:lock");
    }

    @Override
    @Override
    protected <T> Dynamic<T> fixComponent(Dynamic<T> dynamic) {
        return LockComponentPredicateFix.fixLock(dynamic);
    }

    public static <T> Dynamic<T> fixLock(Dynamic<T> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isPresent()) {
            Dynamic dynamic2 = dynamic.createString("\"" + ESCAPER.escape((String)optional.get()) + "\"");
            Dynamic dynamic3 = dynamic.emptyMap().set("minecraft:custom_name", dynamic2);
            return dynamic.emptyMap().set("components", dynamic3);
        }
        return dynamic.emptyMap();
    }
}

