/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema outputSchema, boolean changesType, String name, DSL.TypeReference type, String choiceName) {
        super(outputSchema, changesType);
        this.name = name;
        this.type = type;
        this.entityName = choiceName;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(this.type);
        Type type2 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type type3 = this.getOutputSchema().getType(this.type);
        Type type4 = this.getOutputSchema().getChoiceType(this.type, this.entityName);
        OpticFinder opticFinder = DSL.namedChoice((String)this.entityName, (Type)type2);
        Type<?> type5 = ExtraDataFixUtils.patchSubType(type2, type, type3);
        return this.fix(type, type3, opticFinder, type4, type5);
    }

    private <S, T, A, B> TypeRewriteRule fix(Type<S> inputType, Type<T> outputType, OpticFinder<A> opticFinder, Type<B> outputSubtype, Type<?> rewrittenType) {
        return this.fixTypeEverywhere(this.name, inputType, outputType, dynamicOps -> input -> {
            Typed typed = new Typed(inputType, dynamicOps, input);
            return typed.update(opticFinder, outputSubtype, object -> {
                Typed typed = new Typed(rewrittenType, dynamicOps, object);
                return Util.writeAndReadTypedOrThrow(typed, outputSubtype, this::fix).getValue();
            }).getValue();
        });
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

