/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.templates.TypeTemplate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Supplier;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class V3818_3
extends NamespacedSchema {
    public V3818_3(int versionKey, Schema parent) {
        super(versionKey, parent);
    }

    public static SequencedMap<String, Supplier<TypeTemplate>> components(Schema schema) {
        LinkedHashMap<String, Supplier<TypeTemplate>> sequencedMap = new LinkedHashMap<String, Supplier<TypeTemplate>>();
        sequencedMap.put("minecraft:bees", () -> DSL.list((TypeTemplate)DSL.optionalFields((String)"entity_data", (TypeTemplate)References.ENTITY_TREE.in(schema))));
        sequencedMap.put("minecraft:block_entity_data", () -> References.BLOCK_ENTITY.in(schema));
        sequencedMap.put("minecraft:bundle_contents", () -> DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)));
        sequencedMap.put("minecraft:can_break", () -> DSL.optionalFields((String)"predicates", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"blocks", (TypeTemplate)DSL.or((TypeTemplate)References.BLOCK_NAME.in(schema), (TypeTemplate)DSL.list((TypeTemplate)References.BLOCK_NAME.in(schema)))))));
        sequencedMap.put("minecraft:can_place_on", () -> DSL.optionalFields((String)"predicates", (TypeTemplate)DSL.list((TypeTemplate)DSL.optionalFields((String)"blocks", (TypeTemplate)DSL.or((TypeTemplate)References.BLOCK_NAME.in(schema), (TypeTemplate)DSL.list((TypeTemplate)References.BLOCK_NAME.in(schema)))))));
        sequencedMap.put("minecraft:charged_projectiles", () -> DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)));
        sequencedMap.put("minecraft:container", () -> DSL.list((TypeTemplate)DSL.optionalFields((String)"item", (TypeTemplate)References.ITEM_STACK.in(schema))));
        sequencedMap.put("minecraft:entity_data", () -> References.ENTITY_TREE.in(schema));
        sequencedMap.put("minecraft:pot_decorations", () -> DSL.list((TypeTemplate)References.ITEM_NAME.in(schema)));
        sequencedMap.put("minecraft:food", () -> DSL.optionalFields((String)"using_converts_to", (TypeTemplate)References.ITEM_STACK.in(schema)));
        return sequencedMap;
    }

    public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> map, Map<String, Supplier<TypeTemplate>> map2) {
        super.registerTypes(schema, map, map2);
        schema.registerType(true, References.DATA_COMPONENTS, () -> DSL.optionalFieldsLazy(V3818_3.components(schema)));
    }
}

