/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.Supplier;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.util.profiling.metrics.MetricCategory;

public interface ProfilerFiller {
    public static final String ROOT = "root";

    public void startTick();

    public void endTick();

    public void push(String var1);

    public void push(Supplier<String> var1);

    public void pop();

    public void popPush(String var1);

    public void popPush(Supplier<String> var1);

    default public void addZoneText(String label) {
    }

    default public void addZoneValue(long value) {
    }

    default public void setZoneColor(int color) {
    }

    default public Zone zone(String name) {
        this.push(name);
        return new Zone(this);
    }

    default public Zone zone(Supplier<String> nameSupplier) {
        this.push(nameSupplier);
        return new Zone(this);
    }

    public void markForCharting(MetricCategory var1);

    default public void incrementCounter(String marker) {
        this.incrementCounter(marker, 1);
    }

    public void incrementCounter(String var1, int var2);

    default public void incrementCounter(Supplier<String> markerGetter) {
        this.incrementCounter(markerGetter, 1);
    }

    public void incrementCounter(Supplier<String> var1, int var2);

    public static ProfilerFiller combine(ProfilerFiller first, ProfilerFiller second) {
        if (first == InactiveProfiler.INSTANCE) {
            return second;
        }
        if (second == InactiveProfiler.INSTANCE) {
            return first;
        }
        return new CombinedProfileFiller(first, second);
    }

    public static class CombinedProfileFiller
    implements ProfilerFiller {
        private final ProfilerFiller first;
        private final ProfilerFiller second;

        public CombinedProfileFiller(ProfilerFiller first, ProfilerFiller second) {
            this.first = first;
            this.second = second;
        }

        @Override
        @Override
        public void startTick() {
            this.first.startTick();
            this.second.startTick();
        }

        @Override
        @Override
        public void endTick() {
            this.first.endTick();
            this.second.endTick();
        }

        @Override
        @Override
        public void push(String location) {
            this.first.push(location);
            this.second.push(location);
        }

        @Override
        @Override
        public void push(Supplier<String> locationGetter) {
            this.first.push(locationGetter);
            this.second.push(locationGetter);
        }

        @Override
        @Override
        public void markForCharting(MetricCategory type) {
            this.first.markForCharting(type);
            this.second.markForCharting(type);
        }

        @Override
        @Override
        public void pop() {
            this.first.pop();
            this.second.pop();
        }

        @Override
        @Override
        public void popPush(String location) {
            this.first.popPush(location);
            this.second.popPush(location);
        }

        @Override
        @Override
        public void popPush(Supplier<String> locationGetter) {
            this.first.popPush(locationGetter);
            this.second.popPush(locationGetter);
        }

        @Override
        @Override
        public void incrementCounter(String marker, int num) {
            this.first.incrementCounter(marker, num);
            this.second.incrementCounter(marker, num);
        }

        @Override
        @Override
        public void incrementCounter(Supplier<String> markerGetter, int num) {
            this.first.incrementCounter(markerGetter, num);
            this.second.incrementCounter(markerGetter, num);
        }

        @Override
        @Override
        public void addZoneText(String label) {
            this.first.addZoneText(label);
            this.second.addZoneText(label);
        }

        @Override
        @Override
        public void addZoneValue(long value) {
            this.first.addZoneValue(value);
            this.second.addZoneValue(value);
        }

        @Override
        @Override
        public void setZoneColor(int color) {
            this.first.setZoneColor(color);
            this.second.setZoneColor(color);
        }
    }
}

