/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;

public class SimpleContainer
implements Container,
StackedContentsCompatible {
    private final int size;
    public final NonNullList<ItemStack> items;
    @Nullable
    private List<ContainerListener> listeners;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    @Nullable
    protected InventoryHolder bukkitOwner;
    @Nullable
    private Supplier<? extends InventoryHolder> bukkitOwnerCreator;

    @Override
    public List<ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int i) {
        this.maxStack = i;
    }

    @Override
    public InventoryHolder getOwner() {
        if (this.bukkitOwner == null && this.bukkitOwnerCreator != null) {
            this.bukkitOwner = this.bukkitOwnerCreator.get();
        }
        return this.bukkitOwner;
    }

    @Override
    public Location getLocation() {
        InventoryHolder inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return blockInventoryHolder.getBlock().getLocation();
        }
        inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return entity.getLocation();
        }
        return null;
    }

    public SimpleContainer(SimpleContainer original) {
        this(original.size);
        for (int slot = 0; slot < original.size; ++slot) {
            this.items.set(slot, original.items.get(slot).copy());
        }
    }

    public SimpleContainer(int size) {
        this(size, null);
    }

    public SimpleContainer(Supplier<? extends InventoryHolder> bukkitOwnerCreator, int size) {
        this(size);
        this.bukkitOwnerCreator = bukkitOwnerCreator;
    }

    public SimpleContainer(int i, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.size = i;
        this.items = NonNullList.withSize(i, ItemStack.EMPTY);
    }

    public SimpleContainer(ItemStack ... items) {
        this.size = items.length;
        this.items = NonNullList.of(ItemStack.EMPTY, items);
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.items.size() ? this.items.get(slot) : ItemStack.EMPTY;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(itemstack -> !itemstack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, slot, amount);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemType(Item item, int count) {
        ItemStack itemstack = new ItemStack(item, 0);
        for (int j = this.size - 1; j >= 0; --j) {
            ItemStack itemstack1 = this.getItem(j);
            if (!itemstack1.getItem().equals(item)) continue;
            int k = count - itemstack.getCount();
            ItemStack itemstack2 = itemstack1.split(k);
            itemstack.grow(itemstack2.getCount());
            if (itemstack.getCount() == count) break;
        }
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack1 = stack.copy();
        this.moveItemToOccupiedSlotsWithSameType(itemstack1);
        if (itemstack1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(itemstack1);
        return itemstack1.isEmpty() ? ItemStack.EMPTY : itemstack1;
    }

    public boolean canAddItem(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemstack1 : this.items) {
            if (!itemstack1.isEmpty() && (!ItemStack.isSameItemSameComponents(itemstack1, stack) || itemstack1.getCount() >= itemstack1.getMaxStackSize())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemstack = this.items.get(slot);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, ItemStack.EMPTY);
        return itemstack;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    @Override
    public int getContainerSize() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @Override
    public void setChanged() {
        if (this.listeners != null) {
            for (ContainerListener iinventorylistener : this.listeners) {
                iinventorylistener.containerChanged(this);
            }
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    @Override
    public void fillStackedContents(StackedItemContents finder) {
        for (ItemStack itemstack : this.items) {
            finder.accountStack(itemstack);
        }
    }

    public String toString() {
        return this.items.stream().filter(itemstack -> !itemstack.isEmpty()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemstack1 = this.getItem(i);
            if (!itemstack1.isEmpty()) continue;
            this.setItem(i, stack.copyAndClear());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemstack1 = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents(itemstack1, stack)) continue;
            this.moveItemsBetweenStacks(stack, itemstack1);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack source, ItemStack target) {
        int i = this.getMaxStackSize(target);
        int j = Math.min(source.getCount(), i - target.getCount());
        if (j > 0) {
            target.grow(j);
            source.shrink(j);
            this.setChanged();
        }
    }

    public void fromTag(ListTag list, HolderLookup.Provider registries) {
        this.clearContent();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack.parse(registries, list.getCompound(i)).ifPresent(this::addItem);
        }
    }

    public ListTag createTag(HolderLookup.Provider registries) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            nbttaglist.add(itemstack.save(registries));
        }
        return nbttaglist;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }
}

