/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

class RaidOmenMobEffect
extends MobEffect {
    protected RaidOmenMobEffect(MobEffectCategory category, int color, ParticleOptions particleEffect) {
        super(category, color, particleEffect);
    }

    @Override
    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration == 1;
    }

    @Override
    @Override
    public boolean applyEffectTick(ServerLevel world, LivingEntity entity, int amplifier) {
        if (entity instanceof ServerPlayer) {
            BlockPos blockPos;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!entity.isSpectator() && (blockPos = serverPlayer.getRaidOmenPosition()) != null) {
                world.getRaids().createOrExtendRaid(serverPlayer, blockPos);
                serverPlayer.clearRaidOmenPosition();
                return false;
            }
        }
        return true;
    }
}

