/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;

public class AnimationState {
    private static final int STOPPED = Integer.MIN_VALUE;
    private int startTick = Integer.MIN_VALUE;

    public void start(int tick) {
        this.startTick = tick;
    }

    public void startIfStopped(int tick) {
        if (!this.isStarted()) {
            this.start(tick);
        }
    }

    public void animateWhen(boolean running, int tick) {
        if (running) {
            this.startIfStopped(tick);
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.startTick = Integer.MIN_VALUE;
    }

    public void ifStarted(Consumer<AnimationState> consumer) {
        if (this.isStarted()) {
            consumer.accept(this);
        }
    }

    public void fastForward(int ticks, float speedMultiplier) {
        if (!this.isStarted()) {
            return;
        }
        this.startTick -= (int)((float)ticks * speedMultiplier);
    }

    public long getTimeInMillis(float age) {
        float f = age - (float)this.startTick;
        return (long)(f * 50.0f);
    }

    public boolean isStarted() {
        return this.startTick != Integer.MIN_VALUE;
    }

    public void copyFrom(AnimationState state) {
        this.startTick = state.startTick;
    }
}

