/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum ConversionType {
    SINGLE(true){

        @Override
        void convert(Mob oldEntity, Mob newEntity, ConversionParams context) {
            Entity entity2;
            Entity entity12;
            Entity entity = oldEntity.getFirstPassenger();
            newEntity.copyPosition(oldEntity);
            newEntity.setDeltaMovement(oldEntity.getDeltaMovement());
            if (entity != null) {
                entity.stopRiding();
                entity.boardingCooldown = 0;
                for (Entity entity12 : newEntity.getPassengers()) {
                    entity12.stopRiding();
                    entity12.remove(Entity.RemovalReason.DISCARDED, EntityRemoveEvent.Cause.TRANSFORMATION);
                }
                entity.startRiding(newEntity);
            }
            if ((entity2 = oldEntity.getVehicle()) != null) {
                oldEntity.stopRiding();
                newEntity.startRiding(entity2);
            }
            if (context.keepEquipment()) {
                for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                    ItemStack itemstack = oldEntity.getItemBySlot(enumitemslot);
                    if (itemstack.isEmpty()) continue;
                    newEntity.setItemSlot(enumitemslot, itemstack.copyAndClear());
                    newEntity.setDropChance(enumitemslot, oldEntity.getEquipmentDropChance(enumitemslot));
                }
            }
            newEntity.fallDistance = oldEntity.fallDistance;
            newEntity.setSharedFlag(7, oldEntity.isFallFlying());
            newEntity.lastHurtByPlayerTime = oldEntity.lastHurtByPlayerTime;
            newEntity.hurtTime = oldEntity.hurtTime;
            newEntity.yBodyRot = oldEntity.yBodyRot;
            newEntity.setOnGround(oldEntity.onGround());
            Optional<BlockPos> optional = oldEntity.getSleepingPos();
            Objects.requireNonNull(newEntity);
            optional.ifPresent(newEntity::setSleepingPos);
            entity12 = oldEntity.getLeashHolder();
            if (entity12 != null) {
                newEntity.setLeashedTo(entity12, true);
            }
            this.convertCommon(oldEntity, newEntity, context);
        }
    }
    ,
    SPLIT_ON_DEATH(false){

        @Override
        void convert(Mob oldEntity, Mob newEntity, ConversionParams context) {
            Entity entity1;
            Entity entity = oldEntity.getFirstPassenger();
            if (entity != null) {
                entity.stopRiding();
            }
            if ((entity1 = oldEntity.getLeashHolder()) != null) {
                oldEntity.dropLeash(true, true);
            }
            this.convertCommon(oldEntity, newEntity, context);
        }
    };

    private final boolean discardAfterConversion;

    private ConversionType(boolean flag) {
        this.discardAfterConversion = flag;
    }

    public boolean shouldDiscardAfterConversion() {
        return this.discardAfterConversion;
    }

    abstract void convert(Mob var1, Mob var2, ConversionParams var3);

    void convertCommon(Mob oldEntity, Mob newEntity, ConversionParams context) {
        Zombie entityzombie;
        newEntity.setAbsorptionAmount(oldEntity.getAbsorptionAmount());
        for (MobEffectInstance mobeffect : oldEntity.getActiveEffects()) {
            newEntity.addEffect(new MobEffectInstance(mobeffect));
        }
        if (oldEntity.isBaby()) {
            newEntity.setBaby(true);
        }
        if (oldEntity instanceof AgeableMob) {
            AgeableMob entityageable = (AgeableMob)oldEntity;
            if (newEntity instanceof AgeableMob) {
                AgeableMob entityageable1 = (AgeableMob)newEntity;
                entityageable1.setAge(entityageable.getAge());
                entityageable1.forcedAge = entityageable.forcedAge;
                entityageable1.forcedAgeTimer = entityageable.forcedAgeTimer;
            }
        }
        Brain<UUID> behaviorcontroller = oldEntity.getBrain();
        Brain<?> behaviorcontroller1 = newEntity.getBrain();
        if (behaviorcontroller.checkMemory(MemoryModuleType.ANGRY_AT, MemoryStatus.REGISTERED) && behaviorcontroller.hasMemoryValue(MemoryModuleType.ANGRY_AT)) {
            behaviorcontroller1.setMemory(MemoryModuleType.ANGRY_AT, behaviorcontroller.getMemory(MemoryModuleType.ANGRY_AT));
        }
        if (context.preserveCanPickUpLoot()) {
            newEntity.setCanPickUpLoot(oldEntity.canPickUpLoot());
        }
        newEntity.setLeftHanded(oldEntity.isLeftHanded());
        newEntity.setNoAi(oldEntity.isNoAi());
        if (oldEntity.isPersistenceRequired()) {
            newEntity.setPersistenceRequired();
        }
        if (oldEntity.hasCustomName()) {
            newEntity.setCustomName(oldEntity.getCustomName());
            newEntity.setCustomNameVisible(oldEntity.isCustomNameVisible());
        }
        newEntity.setSharedFlagOnFire(oldEntity.isOnFire());
        newEntity.setInvulnerable(oldEntity.isInvulnerable());
        newEntity.setNoGravity(oldEntity.isNoGravity());
        newEntity.setPortalCooldown(oldEntity.getPortalCooldown());
        newEntity.setSilent(oldEntity.isSilent());
        Set<String> set = oldEntity.getTags();
        Objects.requireNonNull(newEntity);
        set.forEach(newEntity::addTag);
        if (context.team() != null) {
            Scoreboard scoreboard = newEntity.level().getScoreboard();
            scoreboard.addPlayerToTeam(newEntity.getStringUUID(), context.team());
            if (oldEntity.getTeam() != null && oldEntity.getTeam() == context.team()) {
                scoreboard.removePlayerFromTeam(oldEntity.getStringUUID(), oldEntity.getTeam());
            }
        }
        if (oldEntity instanceof Zombie && (entityzombie = (Zombie)oldEntity).canBreakDoors() && newEntity instanceof Zombie) {
            Zombie entityzombie1 = (Zombie)newEntity;
            entityzombie1.setCanBreakDoors(true);
        }
    }
}

