/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int NO_BRIGHTNESS_OVERRIDE = -1;
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_POS_ROT_INTERPOLATION_DURATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Vector3f> DATA_TRANSLATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Vector3f> DATA_SCALE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.VECTOR3);
    private static final EntityDataAccessor<Quaternionf> DATA_LEFT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Quaternionf> DATA_RIGHT_ROTATION_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.QUATERNION);
    private static final EntityDataAccessor<Byte> DATA_BILLBOARD_RENDER_CONSTRAINTS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BRIGHTNESS_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_VIEW_RANGE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_RADIUS_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_SHADOW_STRENGTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_GLOW_COLOR_OVERRIDE_ID = SynchedEntityData.defineId(Display.class, EntityDataSerializers.INT);
    private static final IntSet RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TRANSLATION_ID.id(), DATA_SCALE_ID.id(), DATA_LEFT_ROTATION_ID.id(), DATA_RIGHT_ROTATION_ID.id(), DATA_BILLBOARD_RENDER_CONSTRAINTS_ID.id(), DATA_BRIGHTNESS_OVERRIDE_ID.id(), DATA_SHADOW_RADIUS_ID.id(), DATA_SHADOW_STRENGTH_ID.id()});
    private static final float INITIAL_SHADOW_RADIUS = 0.0f;
    private static final float INITIAL_SHADOW_STRENGTH = 1.0f;
    private static final int NO_GLOW_COLOR_OVERRIDE = -1;
    public static final String TAG_POS_ROT_INTERPOLATION_DURATION = "teleport_duration";
    public static final String TAG_TRANSFORMATION_INTERPOLATION_DURATION = "interpolation_duration";
    public static final String TAG_TRANSFORMATION_START_INTERPOLATION = "start_interpolation";
    public static final String TAG_TRANSFORMATION = "transformation";
    public static final String TAG_BILLBOARD = "billboard";
    public static final String TAG_BRIGHTNESS = "brightness";
    public static final String TAG_VIEW_RANGE = "view_range";
    public static final String TAG_SHADOW_RADIUS = "shadow_radius";
    public static final String TAG_SHADOW_STRENGTH = "shadow_strength";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_GLOW_COLOR_OVERRIDE = "glow_color_override";
    private long interpolationStartClientTick = Integer.MIN_VALUE;
    private int interpolationDuration;
    private float lastProgress;
    private AABB cullingBoundingBox;
    private boolean noCulling = true;
    protected boolean updateRenderState;
    private boolean updateStartTick;
    private boolean updateInterpolationDuration;
    @Nullable
    private RenderState renderState;
    @Nullable
    private PosRotInterpolationTarget posRotInterpolationTarget;

    public Display(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
        this.cullingBoundingBox = this.getBoundingBox();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (DATA_HEIGHT_ID.equals(data) || DATA_WIDTH_ID.equals(data)) {
            this.updateCulling();
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID.equals(data)) {
            this.updateStartTick = true;
        }
        if (DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID.equals(data)) {
            this.updateInterpolationDuration = true;
        }
        if (RENDER_STATE_IDS.contains(data.id())) {
            this.updateRenderState = true;
        }
    }

    @Override
    public final boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    public static Transformation createTransformation(SynchedEntityData dataTracker) {
        Vector3f vector3f = dataTracker.get(DATA_TRANSLATION_ID);
        Quaternionf quaternionf = dataTracker.get(DATA_LEFT_ROTATION_ID);
        Vector3f vector3f2 = dataTracker.get(DATA_SCALE_ID);
        Quaternionf quaternionf2 = dataTracker.get(DATA_RIGHT_ROTATION_ID);
        return new Transformation(vector3f, quaternionf, vector3f2, quaternionf2);
    }

    @Override
    public void tick() {
        Entity entity = this.getVehicle();
        if (entity != null && entity.isRemoved()) {
            this.stopRiding();
        }
        if (this.level().isClientSide) {
            if (this.updateStartTick) {
                this.updateStartTick = false;
                int i = this.getTransformationInterpolationDelay();
                this.interpolationStartClientTick = this.tickCount + i;
            }
            if (this.updateInterpolationDuration) {
                this.updateInterpolationDuration = false;
                this.interpolationDuration = this.getTransformationInterpolationDuration();
            }
            if (this.updateRenderState) {
                this.updateRenderState = false;
                boolean bl = this.interpolationDuration != 0;
                this.renderState = bl && this.renderState != null ? this.createInterpolatedRenderState(this.renderState, this.lastProgress) : this.createFreshRenderState();
                this.updateRenderSubState(bl, this.lastProgress);
            }
            if (this.posRotInterpolationTarget != null) {
                if (this.posRotInterpolationTarget.steps == 0) {
                    this.posRotInterpolationTarget.applyTargetPosAndRot(this);
                    this.setOldPosAndRot();
                    this.posRotInterpolationTarget = null;
                } else {
                    this.posRotInterpolationTarget.applyLerpStep(this);
                    --this.posRotInterpolationTarget.steps;
                    if (this.posRotInterpolationTarget.steps == 0) {
                        this.posRotInterpolationTarget = null;
                    }
                }
            }
        }
    }

    protected abstract void updateRenderSubState(boolean var1, float var2);

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_POS_ROT_INTERPOLATION_DURATION_ID, 0);
        builder.define(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, 0);
        builder.define(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, 0);
        builder.define(DATA_TRANSLATION_ID, new Vector3f());
        builder.define(DATA_SCALE_ID, new Vector3f(1.0f, 1.0f, 1.0f));
        builder.define(DATA_RIGHT_ROTATION_ID, new Quaternionf());
        builder.define(DATA_LEFT_ROTATION_ID, new Quaternionf());
        builder.define(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, BillboardConstraints.FIXED.getId());
        builder.define(DATA_BRIGHTNESS_OVERRIDE_ID, -1);
        builder.define(DATA_VIEW_RANGE_ID, Float.valueOf(1.0f));
        builder.define(DATA_SHADOW_RADIUS_ID, Float.valueOf(0.0f));
        builder.define(DATA_SHADOW_STRENGTH_ID, Float.valueOf(1.0f));
        builder.define(DATA_WIDTH_ID, Float.valueOf(0.0f));
        builder.define(DATA_HEIGHT_ID, Float.valueOf(0.0f));
        builder.define(DATA_GLOW_COLOR_OVERRIDE_ID, -1);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains(TAG_TRANSFORMATION)) {
            Transformation.EXTENDED_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_TRANSFORMATION)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(pair -> this.setTransformation((Transformation)pair.getFirst()));
        }
        if (nbt.contains(TAG_TRANSFORMATION_INTERPOLATION_DURATION, 99)) {
            int i = nbt.getInt(TAG_TRANSFORMATION_INTERPOLATION_DURATION);
            this.setTransformationInterpolationDuration(i);
        }
        if (nbt.contains(TAG_TRANSFORMATION_START_INTERPOLATION, 99)) {
            int j = nbt.getInt(TAG_TRANSFORMATION_START_INTERPOLATION);
            this.setTransformationInterpolationDelay(j);
        }
        if (nbt.contains(TAG_POS_ROT_INTERPOLATION_DURATION, 99)) {
            int k = nbt.getInt(TAG_POS_ROT_INTERPOLATION_DURATION);
            this.setPosRotInterpolationDuration(Mth.clamp(k, 0, 59));
        }
        if (nbt.contains(TAG_BILLBOARD, 8)) {
            BillboardConstraints.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_BILLBOARD)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(pair -> this.setBillboardConstraints((BillboardConstraints)pair.getFirst()));
        }
        if (nbt.contains(TAG_VIEW_RANGE, 99)) {
            this.setViewRange(nbt.getFloat(TAG_VIEW_RANGE));
        }
        if (nbt.contains(TAG_SHADOW_RADIUS, 99)) {
            this.setShadowRadius(nbt.getFloat(TAG_SHADOW_RADIUS));
        }
        if (nbt.contains(TAG_SHADOW_STRENGTH, 99)) {
            this.setShadowStrength(nbt.getFloat(TAG_SHADOW_STRENGTH));
        }
        if (nbt.contains(TAG_WIDTH, 99)) {
            this.setWidth(nbt.getFloat(TAG_WIDTH));
        }
        if (nbt.contains(TAG_HEIGHT, 99)) {
            this.setHeight(nbt.getFloat(TAG_HEIGHT));
        }
        if (nbt.contains(TAG_GLOW_COLOR_OVERRIDE, 99)) {
            this.setGlowColorOverride(nbt.getInt(TAG_GLOW_COLOR_OVERRIDE));
        }
        if (nbt.contains(TAG_BRIGHTNESS, 10)) {
            Brightness.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_BRIGHTNESS)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(pair -> this.setBrightnessOverride((Brightness)pair.getFirst()));
        } else {
            this.setBrightnessOverride(null);
        }
    }

    public void setTransformation(Transformation transformation) {
        this.entityData.set(DATA_TRANSLATION_ID, transformation.getTranslation());
        this.entityData.set(DATA_LEFT_ROTATION_ID, transformation.getLeftRotation());
        this.entityData.set(DATA_SCALE_ID, transformation.getScale());
        this.entityData.set(DATA_RIGHT_ROTATION_ID, transformation.getRightRotation());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        Transformation.EXTENDED_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)Display.createTransformation(this.entityData)).ifSuccess(transformations -> nbt.put(TAG_TRANSFORMATION, (Tag)transformations));
        BillboardConstraints.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBillboardConstraints()).ifSuccess(billboard -> nbt.put(TAG_BILLBOARD, (Tag)billboard));
        nbt.putInt(TAG_TRANSFORMATION_INTERPOLATION_DURATION, this.getTransformationInterpolationDuration());
        nbt.putInt(TAG_POS_ROT_INTERPOLATION_DURATION, this.getPosRotInterpolationDuration());
        nbt.putFloat(TAG_VIEW_RANGE, this.getViewRange());
        nbt.putFloat(TAG_SHADOW_RADIUS, this.getShadowRadius());
        nbt.putFloat(TAG_SHADOW_STRENGTH, this.getShadowStrength());
        nbt.putFloat(TAG_WIDTH, this.getWidth());
        nbt.putFloat(TAG_HEIGHT, this.getHeight());
        nbt.putInt(TAG_GLOW_COLOR_OVERRIDE, this.getGlowColorOverride());
        Brightness brightness = this.getBrightnessOverride();
        if (brightness != null) {
            Brightness.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)brightness).ifSuccess(brightnessx -> nbt.put(TAG_BRIGHTNESS, (Tag)brightnessx));
        }
    }

    @Override
    public void cancelLerp() {
        this.posRotInterpolationTarget = null;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        int i = this.getPosRotInterpolationDuration();
        this.posRotInterpolationTarget = new PosRotInterpolationTarget(i, x, y, z, yaw, pitch);
    }

    @Override
    public double lerpTargetX() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.posRotInterpolationTarget != null ? this.posRotInterpolationTarget.targetZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.posRotInterpolationTarget != null ? (float)this.posRotInterpolationTarget.targetXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.posRotInterpolationTarget != null ? (float)this.posRotInterpolationTarget.targetYRot : this.getYRot();
    }

    public AABB getBoundingBoxForCulling() {
        return this.cullingBoundingBox;
    }

    public boolean affectedByCulling() {
        return !this.noCulling;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Nullable
    public RenderState renderState() {
        return this.renderState;
    }

    public void setTransformationInterpolationDuration(int interpolationDuration) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID, interpolationDuration);
    }

    public int getTransformationInterpolationDuration() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_DURATION_ID);
    }

    public void setTransformationInterpolationDelay(int startInterpolation) {
        this.entityData.set(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID, startInterpolation, true);
    }

    public int getTransformationInterpolationDelay() {
        return this.entityData.get(DATA_TRANSFORMATION_INTERPOLATION_START_DELTA_TICKS_ID);
    }

    private void setPosRotInterpolationDuration(int teleportDuration) {
        this.entityData.set(DATA_POS_ROT_INTERPOLATION_DURATION_ID, teleportDuration);
    }

    private int getPosRotInterpolationDuration() {
        return this.entityData.get(DATA_POS_ROT_INTERPOLATION_DURATION_ID);
    }

    public void setBillboardConstraints(BillboardConstraints billboardMode) {
        this.entityData.set(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, billboardMode.getId());
    }

    public BillboardConstraints getBillboardConstraints() {
        return BillboardConstraints.BY_ID.apply(this.entityData.get(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID).byteValue());
    }

    public void setBrightnessOverride(@Nullable Brightness brightness) {
        this.entityData.set(DATA_BRIGHTNESS_OVERRIDE_ID, brightness != null ? brightness.pack() : -1);
    }

    @Nullable
    public Brightness getBrightnessOverride() {
        int i = this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
        return i != -1 ? Brightness.unpack(i) : null;
    }

    private int getPackedBrightnessOverride() {
        return this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
    }

    public void setViewRange(float viewRange) {
        this.entityData.set(DATA_VIEW_RANGE_ID, Float.valueOf(viewRange));
    }

    public float getViewRange() {
        return this.entityData.get(DATA_VIEW_RANGE_ID).floatValue();
    }

    public void setShadowRadius(float shadowRadius) {
        this.entityData.set(DATA_SHADOW_RADIUS_ID, Float.valueOf(shadowRadius));
    }

    public float getShadowRadius() {
        return this.entityData.get(DATA_SHADOW_RADIUS_ID).floatValue();
    }

    public void setShadowStrength(float shadowStrength) {
        this.entityData.set(DATA_SHADOW_STRENGTH_ID, Float.valueOf(shadowStrength));
    }

    public float getShadowStrength() {
        return this.entityData.get(DATA_SHADOW_STRENGTH_ID).floatValue();
    }

    public void setWidth(float width) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(width));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float height) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(height));
    }

    public int getGlowColorOverride() {
        return this.entityData.get(DATA_GLOW_COLOR_OVERRIDE_ID);
    }

    public void setGlowColorOverride(int glowColorOverride) {
        this.entityData.set(DATA_GLOW_COLOR_OVERRIDE_ID, glowColorOverride);
    }

    public float calculateInterpolationProgress(float delta) {
        float h;
        int i = this.interpolationDuration;
        if (i <= 0) {
            return 1.0f;
        }
        float f = (long)this.tickCount - this.interpolationStartClientTick;
        float g = f + delta;
        this.lastProgress = h = Mth.clamp(Mth.inverseLerp(g, 0.0f, i), 0.0f, 1.0f);
        return h;
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    @Override
    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        this.updateCulling();
    }

    private void updateCulling() {
        float f = this.getWidth();
        float g = this.getHeight();
        this.noCulling = f == 0.0f || g == 0.0f;
        float h = f / 2.0f;
        double d = this.getX();
        double e = this.getY();
        double i = this.getZ();
        this.cullingBoundingBox = new AABB(d - (double)h, e, i - (double)h, d + (double)h, e + (double)g, i + (double)h);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < Mth.square((double)this.getViewRange() * 64.0 * Display.getViewScale());
    }

    @Override
    public int getTeamColor() {
        int i = this.getGlowColorOverride();
        return i != -1 ? i : super.getTeamColor();
    }

    private RenderState createFreshRenderState() {
        return new RenderState(GenericInterpolator.constant(Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), FloatInterpolator.constant(this.getShadowRadius()), FloatInterpolator.constant(this.getShadowStrength()), this.getGlowColorOverride());
    }

    private RenderState createInterpolatedRenderState(RenderState state, float lerpProgress) {
        Transformation transformation = state.transformation.get(lerpProgress);
        float f = state.shadowRadius.get(lerpProgress);
        float g = state.shadowStrength.get(lerpProgress);
        return new RenderState(new TransformationInterpolator(transformation, Display.createTransformation(this.entityData)), this.getBillboardConstraints(), this.getPackedBrightnessOverride(), new LinearFloatInterpolator(f, this.getShadowRadius()), new LinearFloatInterpolator(g, this.getShadowStrength()), this.getGlowColorOverride());
    }

    public record RenderState(GenericInterpolator<Transformation> transformation, BillboardConstraints billboardConstraints, int brightnessOverride, FloatInterpolator shadowRadius, FloatInterpolator shadowStrength, int glowColorOverride) {
    }

    static class PosRotInterpolationTarget {
        int steps;
        final double targetX;
        final double targetY;
        final double targetZ;
        final double targetYRot;
        final double targetXRot;

        PosRotInterpolationTarget(int step, double x, double y, double z, double yaw, double pitch) {
            this.steps = step;
            this.targetX = x;
            this.targetY = y;
            this.targetZ = z;
            this.targetYRot = yaw;
            this.targetXRot = pitch;
        }

        void applyTargetPosAndRot(Entity entity) {
            entity.setPos(this.targetX, this.targetY, this.targetZ);
            entity.setRot((float)this.targetYRot, (float)this.targetXRot);
        }

        void applyLerpStep(Entity entity) {
            entity.lerpPositionAndRotationStep(this.steps, this.targetX, this.targetY, this.targetZ, this.targetYRot, this.targetXRot);
        }
    }

    public static enum BillboardConstraints implements StringRepresentable
    {
        FIXED(0, "fixed"),
        VERTICAL(1, "vertical"),
        HORIZONTAL(2, "horizontal"),
        CENTER(3, "center");

        public static final Codec<BillboardConstraints> CODEC;
        public static final IntFunction<BillboardConstraints> BY_ID;
        private final byte id;
        private final String name;

        private BillboardConstraints(byte index, String name) {
            this.name = name;
            this.id = index;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        byte getId() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BillboardConstraints::values);
            BY_ID = ByIdMap.continuous(BillboardConstraints::getId, BillboardConstraints.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return delta -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return delta -> value;
        }

        public float get(float var1);
    }

    record TransformationInterpolator(Transformation previous, Transformation current) implements GenericInterpolator<Transformation>
    {
        @Override
        public Transformation get(float f) {
            return (double)f >= 1.0 ? this.current : this.previous.slerp(this.current, f);
        }
    }

    record LinearFloatInterpolator(float previous, float current) implements FloatInterpolator
    {
        @Override
        public float get(float delta) {
            return Mth.lerp(delta, this.previous, this.current);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String TAG_TEXT = "text";
        private static final String TAG_LINE_WIDTH = "line_width";
        private static final String TAG_TEXT_OPACITY = "text_opacity";
        private static final String TAG_BACKGROUND_COLOR = "background";
        private static final String TAG_SHADOW = "shadow";
        private static final String TAG_SEE_THROUGH = "see_through";
        private static final String TAG_USE_DEFAULT_BACKGROUND = "default_background";
        private static final String TAG_ALIGNMENT = "alignment";
        public static final byte FLAG_SHADOW = 1;
        public static final byte FLAG_SEE_THROUGH = 2;
        public static final byte FLAG_USE_DEFAULT_BACKGROUND = 4;
        public static final byte FLAG_ALIGN_LEFT = 8;
        public static final byte FLAG_ALIGN_RIGHT = 16;
        private static final byte INITIAL_TEXT_OPACITY = -1;
        public static final int INITIAL_BACKGROUND = 0x40000000;
        private static final EntityDataAccessor<Component> DATA_TEXT_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.COMPONENT);
        public static final EntityDataAccessor<Integer> DATA_LINE_WIDTH_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        public static final EntityDataAccessor<Integer> DATA_BACKGROUND_COLOR_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.INT);
        private static final EntityDataAccessor<Byte> DATA_TEXT_OPACITY_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final EntityDataAccessor<Byte> DATA_STYLE_FLAGS_ID = SynchedEntityData.defineId(TextDisplay.class, EntityDataSerializers.BYTE);
        private static final IntSet TEXT_RENDER_STATE_IDS = IntSet.of((int[])new int[]{DATA_TEXT_ID.id(), DATA_LINE_WIDTH_ID.id(), DATA_BACKGROUND_COLOR_ID.id(), DATA_TEXT_OPACITY_ID.id(), DATA_STYLE_FLAGS_ID.id()});
        @Nullable
        private CachedInfo clientDisplayCache;
        @Nullable
        private TextRenderState textRenderState;

        public TextDisplay(EntityType<?> type, Level world) {
            super(type, world);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder builder) {
            super.defineSynchedData(builder);
            builder.define(DATA_TEXT_ID, Component.empty());
            builder.define(DATA_LINE_WIDTH_ID, 200);
            builder.define(DATA_BACKGROUND_COLOR_ID, 0x40000000);
            builder.define(DATA_TEXT_OPACITY_ID, (byte)-1);
            builder.define(DATA_STYLE_FLAGS_ID, (byte)0);
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
            super.onSyncedDataUpdated(data);
            if (TEXT_RENDER_STATE_IDS.contains(data.id())) {
                this.updateRenderState = true;
            }
        }

        public Component getText() {
            return this.entityData.get(DATA_TEXT_ID);
        }

        public void setText(Component text) {
            this.entityData.set(DATA_TEXT_ID, text);
        }

        public int getLineWidth() {
            return this.entityData.get(DATA_LINE_WIDTH_ID);
        }

        private void setLineWidth(int lineWidth) {
            this.entityData.set(DATA_LINE_WIDTH_ID, lineWidth);
        }

        public byte getTextOpacity() {
            return this.entityData.get(DATA_TEXT_OPACITY_ID);
        }

        public void setTextOpacity(byte textOpacity) {
            this.entityData.set(DATA_TEXT_OPACITY_ID, textOpacity);
        }

        public int getBackgroundColor() {
            return this.entityData.get(DATA_BACKGROUND_COLOR_ID);
        }

        private void setBackgroundColor(int background) {
            this.entityData.set(DATA_BACKGROUND_COLOR_ID, background);
        }

        public byte getFlags() {
            return this.entityData.get(DATA_STYLE_FLAGS_ID);
        }

        public void setFlags(byte flags) {
            this.entityData.set(DATA_STYLE_FLAGS_ID, flags);
        }

        private static byte loadFlag(byte flags, CompoundTag nbt, String nbtKey, byte flag) {
            return nbt.getBoolean(nbtKey) ? (byte)(flags | flag) : flags;
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag nbt) {
            super.readAdditionalSaveData(nbt);
            if (nbt.contains(TAG_LINE_WIDTH, 99)) {
                this.setLineWidth(nbt.getInt(TAG_LINE_WIDTH));
            }
            if (nbt.contains(TAG_TEXT_OPACITY, 99)) {
                this.setTextOpacity(nbt.getByte(TAG_TEXT_OPACITY));
            }
            if (nbt.contains(TAG_BACKGROUND_COLOR, 99)) {
                this.setBackgroundColor(nbt.getInt(TAG_BACKGROUND_COLOR));
            }
            byte b = TextDisplay.loadFlag((byte)0, nbt, TAG_SHADOW, (byte)1);
            b = TextDisplay.loadFlag(b, nbt, TAG_SEE_THROUGH, (byte)2);
            b = TextDisplay.loadFlag(b, nbt, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Optional<Align> optional = Align.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_ALIGNMENT)).result().map(Pair::getFirst);
            if (optional.isPresent()) {
                b = switch (optional.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> b;
                    case 1 -> (byte)(b | 8);
                    case 2 -> (byte)(b | 0x10);
                };
            }
            this.setFlags(b);
            if (nbt.contains(TAG_TEXT, 8)) {
                String string = nbt.getString(TAG_TEXT);
                try {
                    Level level;
                    MutableComponent component = Component.Serializer.fromJson(string, (HolderLookup.Provider)this.registryAccess());
                    if (component != null && (level = this.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        CommandSourceStack commandSourceStack = this.createCommandSourceStackForNameResolution(serverLevel).withPermission(2);
                        MutableComponent component2 = ComponentUtils.updateForEntity(commandSourceStack, component, (Entity)this, 0);
                        this.setText(component2);
                    } else {
                        this.setText(Component.empty());
                    }
                }
                catch (Exception var9) {
                    LOGGER.warn("Failed to parse display entity text {}", (Object)string, (Object)var9);
                }
            }
        }

        private static void storeFlag(byte flags, CompoundTag nbt, String nbtKey, byte flag) {
            nbt.putBoolean(nbtKey, (flags & flag) != 0);
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag nbt) {
            super.addAdditionalSaveData(nbt);
            nbt.putString(TAG_TEXT, Component.Serializer.toJson(this.getText(), this.registryAccess()));
            nbt.putInt(TAG_LINE_WIDTH, this.getLineWidth());
            nbt.putInt(TAG_BACKGROUND_COLOR, this.getBackgroundColor());
            nbt.putByte(TAG_TEXT_OPACITY, this.getTextOpacity());
            byte b = this.getFlags();
            TextDisplay.storeFlag(b, nbt, TAG_SHADOW, (byte)1);
            TextDisplay.storeFlag(b, nbt, TAG_SEE_THROUGH, (byte)2);
            TextDisplay.storeFlag(b, nbt, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Align.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)TextDisplay.getAlign(b)).ifSuccess(tag -> nbt.put(TAG_ALIGNMENT, (Tag)tag));
        }

        @Override
        protected void updateRenderSubState(boolean shouldLerp, float lerpProgress) {
            this.textRenderState = shouldLerp && this.textRenderState != null ? this.createInterpolatedTextRenderState(this.textRenderState, lerpProgress) : this.createFreshTextRenderState();
            this.clientDisplayCache = null;
        }

        @Nullable
        public TextRenderState textRenderState() {
            return this.textRenderState;
        }

        private TextRenderState createFreshTextRenderState() {
            return new TextRenderState(this.getText(), this.getLineWidth(), IntInterpolator.constant(this.getTextOpacity()), IntInterpolator.constant(this.getBackgroundColor()), this.getFlags());
        }

        private TextRenderState createInterpolatedTextRenderState(TextRenderState data, float lerpProgress) {
            int i = data.backgroundColor.get(lerpProgress);
            int j = data.textOpacity.get(lerpProgress);
            return new TextRenderState(this.getText(), this.getLineWidth(), new LinearIntInterpolator(j, this.getTextOpacity()), new ColorInterpolator(i, this.getBackgroundColor()), this.getFlags());
        }

        public CachedInfo cacheDisplay(LineSplitter splitter) {
            if (this.clientDisplayCache == null) {
                this.clientDisplayCache = this.textRenderState != null ? splitter.split(this.textRenderState.text(), this.textRenderState.lineWidth()) : new CachedInfo(List.of(), 0);
            }
            return this.clientDisplayCache;
        }

        public static Align getAlign(byte flags) {
            if ((flags & 8) != 0) {
                return Align.LEFT;
            }
            return (flags & 0x10) != 0 ? Align.RIGHT : Align.CENTER;
        }

        public static enum Align implements StringRepresentable
        {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            public static final Codec<Align> CODEC;
            private final String name;

            private Align(String name) {
                this.name = name;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Align::values);
            }
        }

        public record TextRenderState(Component text, int lineWidth, IntInterpolator textOpacity, IntInterpolator backgroundColor, byte flags) {
        }

        public record CachedInfo(List<CachedLine> lines, int width) {
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(Component var1, int var2);
        }

        public record CachedLine(FormattedCharSequence contents, int width) {
        }
    }

    record LinearIntInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return Mth.lerpInt(delta, this.previous, this.current);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String TAG_ITEM = "item";
        private static final String TAG_ITEM_DISPLAY = "item_display";
        private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.ITEM_STACK);
        private static final EntityDataAccessor<Byte> DATA_ITEM_DISPLAY_ID = SynchedEntityData.defineId(ItemDisplay.class, EntityDataSerializers.BYTE);
        private final SlotAccess slot = SlotAccess.of(this::getItemStack, this::setItemStack);
        @Nullable
        private ItemRenderState itemRenderState;

        public ItemDisplay(EntityType<?> type, Level world) {
            super(type, world);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder builder) {
            super.defineSynchedData(builder);
            builder.define(DATA_ITEM_STACK_ID, ItemStack.EMPTY);
            builder.define(DATA_ITEM_DISPLAY_ID, ItemDisplayContext.NONE.getId());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
            super.onSyncedDataUpdated(data);
            if (DATA_ITEM_STACK_ID.equals(data) || DATA_ITEM_DISPLAY_ID.equals(data)) {
                this.updateRenderState = true;
            }
        }

        public ItemStack getItemStack() {
            return this.entityData.get(DATA_ITEM_STACK_ID);
        }

        public void setItemStack(ItemStack stack) {
            this.entityData.set(DATA_ITEM_STACK_ID, stack);
        }

        public void setItemTransform(ItemDisplayContext transformationMode) {
            this.entityData.set(DATA_ITEM_DISPLAY_ID, transformationMode.getId());
        }

        public ItemDisplayContext getItemTransform() {
            return ItemDisplayContext.BY_ID.apply(this.entityData.get(DATA_ITEM_DISPLAY_ID).byteValue());
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag nbt) {
            super.readAdditionalSaveData(nbt);
            if (nbt.contains(TAG_ITEM)) {
                this.setItemStack(ItemStack.parse(this.registryAccess(), nbt.getCompound(TAG_ITEM)).orElse(ItemStack.EMPTY));
            } else {
                this.setItemStack(ItemStack.EMPTY);
            }
            if (nbt.contains(TAG_ITEM_DISPLAY, 8)) {
                ItemDisplayContext.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_ITEM_DISPLAY)).resultOrPartial(Util.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(mode -> this.setItemTransform((ItemDisplayContext)mode.getFirst()));
            }
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag nbt) {
            super.addAdditionalSaveData(nbt);
            if (!this.getItemStack().isEmpty()) {
                nbt.put(TAG_ITEM, this.getItemStack().save(this.registryAccess()));
            }
            ItemDisplayContext.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getItemTransform()).ifSuccess(nbtx -> nbt.put(TAG_ITEM_DISPLAY, (Tag)nbtx));
        }

        @Override
        public SlotAccess getSlot(int mappedIndex) {
            return mappedIndex == 0 ? this.slot : SlotAccess.NULL;
        }

        @Nullable
        public ItemRenderState itemRenderState() {
            return this.itemRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean shouldLerp, float lerpProgress) {
            ItemStack itemStack = this.getItemStack();
            itemStack.setEntityRepresentation(this);
            this.itemRenderState = new ItemRenderState(itemStack, this.getItemTransform());
        }

        public record ItemRenderState(ItemStack itemStack, ItemDisplayContext itemTransform) {
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return delta -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int previous, int current) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return ARGB.lerp(delta, this.previous, this.current);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String TAG_BLOCK_STATE = "block_state";
        private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(BlockDisplay.class, EntityDataSerializers.BLOCK_STATE);
        @Nullable
        private BlockRenderState blockRenderState;

        public BlockDisplay(EntityType<?> type, Level world) {
            super(type, world);
        }

        @Override
        protected void defineSynchedData(SynchedEntityData.Builder builder) {
            super.defineSynchedData(builder);
            builder.define(DATA_BLOCK_STATE_ID, Blocks.AIR.defaultBlockState());
        }

        @Override
        public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
            super.onSyncedDataUpdated(data);
            if (data.equals(DATA_BLOCK_STATE_ID)) {
                this.updateRenderState = true;
            }
        }

        public BlockState getBlockState() {
            return this.entityData.get(DATA_BLOCK_STATE_ID);
        }

        public void setBlockState(BlockState state) {
            this.entityData.set(DATA_BLOCK_STATE_ID, state);
        }

        @Override
        protected void readAdditionalSaveData(CompoundTag nbt) {
            super.readAdditionalSaveData(nbt);
            this.setBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), nbt.getCompound(TAG_BLOCK_STATE)));
        }

        @Override
        protected void addAdditionalSaveData(CompoundTag nbt) {
            super.addAdditionalSaveData(nbt);
            nbt.put(TAG_BLOCK_STATE, NbtUtils.writeBlockState(this.getBlockState()));
        }

        @Nullable
        public BlockRenderState blockRenderState() {
            return this.blockRenderState;
        }

        @Override
        protected void updateRenderSubState(boolean shouldLerp, float lerpProgress) {
            this.blockRenderState = new BlockRenderState(this.getBlockState());
        }

        public record BlockRenderState(BlockState blockState) {
        }
    }
}

