/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ElytraAnimationState {
    private static final float DEFAULT_X_ROT = 0.2617994f;
    private static final float DEFAULT_Z_ROT = -0.2617994f;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float rotXOld;
    private float rotYOld;
    private float rotZOld;
    private final LivingEntity entity;

    public ElytraAnimationState(LivingEntity entity) {
        this.entity = entity;
    }

    public void tick() {
        float o;
        float n;
        float m;
        this.rotXOld = this.rotX;
        this.rotYOld = this.rotY;
        this.rotZOld = this.rotZ;
        if (this.entity.isFallFlying()) {
            float f = 1.0f;
            Vec3 vec3 = this.entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec32 = vec3.normalize();
                f = 1.0f - (float)Math.pow(-vec32.y, 1.5);
            }
            float g = Mth.lerp(f, 0.2617994f, 0.34906584f);
            float h = Mth.lerp(f, -0.2617994f, -1.5707964f);
            float i = 0.0f;
        } else if (this.entity.isCrouching()) {
            float j = 0.6981317f;
            float k = -0.7853982f;
            float l = 0.08726646f;
        } else {
            m = 0.2617994f;
            n = -0.2617994f;
            o = 0.0f;
        }
        this.rotX += (m - this.rotX) * 0.3f;
        this.rotY += (o - this.rotY) * 0.3f;
        this.rotZ += (n - this.rotZ) * 0.3f;
    }

    public float getRotX(float tickDelta) {
        return Mth.lerp(tickDelta, this.rotXOld, this.rotX);
    }

    public float getRotY(float tickDelta) {
        return Mth.lerp(tickDelta, this.rotYOld, this.rotY);
    }

    public float getRotZ(float tickDelta) {
        return Mth.lerp(tickDelta, this.rotZOld, this.rotZ);
    }
}

