/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.storage.loot.LootTable;

public record EquipmentTable(ResourceKey<LootTable> lootTable, Map<EquipmentSlot, Float> slotDropChances) {
    public static final Codec<Map<EquipmentSlot, Float>> DROP_CHANCES_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)Codec.unboundedMap(EquipmentSlot.CODEC, (Codec)Codec.FLOAT)).xmap(either -> either.map(EquipmentTable::createForAllSlots, Function.identity()), map -> {
        boolean bl = map.values().stream().distinct().count() == 1L;
        boolean bl2 = map.keySet().containsAll(EquipmentSlot.VALUES);
        if (bl && bl2) {
            return Either.left(map.values().stream().findFirst().orElse(Float.valueOf(0.0f)));
        }
        return Either.right(map);
    });
    public static final Codec<EquipmentTable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec(Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(EquipmentTable::lootTable), (App)DROP_CHANCES_CODEC.optionalFieldOf("slot_drop_chances", Map.of()).forGetter(EquipmentTable::slotDropChances)).apply((Applicative)instance, EquipmentTable::new));

    public EquipmentTable(ResourceKey<LootTable> lootTable, float slotDropChances) {
        this(lootTable, EquipmentTable.createForAllSlots(slotDropChances));
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(float dropChance) {
        return EquipmentTable.createForAllSlots(List.of(EquipmentSlot.values()), dropChance);
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(List<EquipmentSlot> slots, float dropChance) {
        HashMap map = Maps.newHashMap();
        for (EquipmentSlot equipmentSlot : slots) {
            map.put(equipmentSlot, Float.valueOf(dropChance));
        }
        return map;
    }
}

