/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.slf4j.Logger;

public class Interaction
extends Entity
implements Attackable,
Targeting {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Float> DATA_WIDTH_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_HEIGHT_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_RESPONSE_ID = SynchedEntityData.defineId(Interaction.class, EntityDataSerializers.BOOLEAN);
    private static final String TAG_WIDTH = "width";
    private static final String TAG_HEIGHT = "height";
    private static final String TAG_ATTACK = "attack";
    private static final String TAG_INTERACTION = "interaction";
    private static final String TAG_RESPONSE = "response";
    @Nullable
    public PlayerAction attack;
    @Nullable
    public PlayerAction interaction;

    public Interaction(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_WIDTH_ID, Float.valueOf(1.0f));
        builder.define(DATA_HEIGHT_ID, Float.valueOf(1.0f));
        builder.define(DATA_RESPONSE_ID, false);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        Logger logger;
        DataResult dataresult;
        if (nbt.contains(TAG_WIDTH, 99)) {
            this.setWidth(nbt.getFloat(TAG_WIDTH));
        }
        if (nbt.contains(TAG_HEIGHT, 99)) {
            this.setHeight(nbt.getFloat(TAG_HEIGHT));
        }
        if (nbt.contains(TAG_ATTACK)) {
            dataresult = PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_ATTACK));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.attack = (PlayerAction)pair.getFirst();
            });
        } else {
            this.attack = null;
        }
        if (nbt.contains(TAG_INTERACTION)) {
            dataresult = PlayerAction.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get(TAG_INTERACTION));
            logger = LOGGER;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(Util.prefix("Interaction entity", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(pair -> {
                this.interaction = (PlayerAction)pair.getFirst();
            });
        } else {
            this.interaction = null;
        }
        this.setResponse(nbt.getBoolean(TAG_RESPONSE));
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putFloat(TAG_WIDTH, this.getWidth());
        nbt.putFloat(TAG_HEIGHT, this.getHeight());
        if (this.attack != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.attack).ifSuccess(nbtbase -> nbt.put(TAG_ATTACK, (Tag)nbtbase));
        }
        if (this.interaction != null) {
            PlayerAction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.interaction).ifSuccess(nbtbase -> nbt.put(TAG_INTERACTION, (Tag)nbtbase));
        }
        nbt.putBoolean(TAG_RESPONSE, this.getResponse());
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (DATA_HEIGHT_ID.equals(data) || DATA_WIDTH_ID.equals(data)) {
            this.refreshDimensions();
        }
    }

    @Override
    public boolean canBeHitByProjectile() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity attacker) {
        if (attacker instanceof Player) {
            Player entityhuman = (Player)attacker;
            DamageSource source = entityhuman.damageSources().playerAttack(entityhuman);
            EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(this, source, 1.0, false);
            if (event.isCancelled()) {
                return true;
            }
            this.attack = new PlayerAction(entityhuman.getUUID(), this.level().getGameTime());
            if (entityhuman instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(entityplayer, this, entityhuman.damageSources().generic(), 1.0f, (float)event.getFinalDamage(), false);
            }
            return !this.getResponse();
        }
        return false;
    }

    @Override
    public final boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return this.getResponse() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        this.interaction = new PlayerAction(player.getUUID(), this.level().getGameTime());
        return InteractionResult.CONSUME;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nullable
    public LivingEntity getLastAttacker() {
        return this.attack != null ? this.level().getPlayerByUUID(this.attack.player()) : null;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.interaction != null ? this.level().getPlayerByUUID(this.interaction.player()) : null;
    }

    public void setWidth(float width) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(width));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float height) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(height));
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    public void setResponse(boolean response) {
        this.entityData.set(DATA_RESPONSE_ID, response);
    }

    public boolean getResponse() {
        return this.entityData.get(DATA_RESPONSE_ID);
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.scalable(this.getWidth(), this.getHeight());
    }

    @Override
    public EntityDimensions getDimensions(Pose pose) {
        return this.getDimensions();
    }

    @Override
    protected AABB makeBoundingBox() {
        return this.getDimensions().makeBoundingBox(this.position());
    }

    public record PlayerAction(UUID player, long timestamp) {
        public static final Codec<PlayerAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("player").forGetter(PlayerAction::player), (App)Codec.LONG.fieldOf("timestamp").forGetter(PlayerAction::timestamp)).apply((Applicative)instance, PlayerAction::new));
    }
}

