/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityTargetEvent;

public interface NeutralMob {
    public static final String TAG_ANGER_TIME = "AngerTime";
    public static final String TAG_ANGRY_AT = "AngryAt";

    public int getRemainingPersistentAngerTime();

    public void setRemainingPersistentAngerTime(int var1);

    @Nullable
    public UUID getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable UUID var1);

    public void startPersistentAngerTimer();

    default public void addPersistentAngerSaveData(CompoundTag nbt) {
        nbt.putInt(TAG_ANGER_TIME, this.getRemainingPersistentAngerTime());
        if (this.getPersistentAngerTarget() != null) {
            nbt.putUUID(TAG_ANGRY_AT, this.getPersistentAngerTarget());
        }
    }

    default public void readPersistentAngerSaveData(Level world, CompoundTag nbt) {
        this.setRemainingPersistentAngerTime(nbt.getInt(TAG_ANGER_TIME));
        if (world instanceof ServerLevel) {
            if (!nbt.hasUUID(TAG_ANGRY_AT)) {
                this.setPersistentAngerTarget(null);
            } else {
                UUID uuid = nbt.getUUID(TAG_ANGRY_AT);
                this.setPersistentAngerTarget(uuid);
                NeutralMob neutralMob = this;
                if (neutralMob instanceof Entity) {
                    Entity entity = (Entity)((Object)neutralMob);
                    if (!entity.firstTick) {
                        this.tickInitialPersistentAnger(world);
                    }
                }
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel world, boolean angerPersistent) {
        LivingEntity entityliving = this.getTarget();
        UUID uuid = this.getPersistentAngerTarget();
        if ((entityliving == null || entityliving.isDeadOrDying()) && uuid != null && world.getEntity(uuid) instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (entityliving != null && !Objects.equals(uuid, entityliving.getUUID())) {
                this.setPersistentAngerTarget(entityliving.getUUID());
                this.startPersistentAngerTimer();
            }
            if (!(this.getRemainingPersistentAngerTime() <= 0 || entityliving != null && entityliving.getType() == EntityType.PLAYER && angerPersistent)) {
                this.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime() - 1);
                if (this.getRemainingPersistentAngerTime() == 0) {
                    this.stopBeingAngry();
                }
            }
        }
    }

    default public boolean isAngryAt(LivingEntity entity, ServerLevel world) {
        return !this.canAttack(entity) ? false : (entity.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(world) ? true : entity.getUUID().equals(this.getPersistentAngerTarget()));
    }

    default public boolean isAngryAtAllPlayers(ServerLevel world) {
        return world.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        return this.getRemainingPersistentAngerTime() > 0;
    }

    default public void playerDied(ServerLevel world, Player player) {
        if (world.getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS) && player.getUUID().equals(this.getPersistentAngerTarget())) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
        this.setRemainingPersistentAngerTime(0);
    }

    @Nullable
    public LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setLastHurtByPlayer(@Nullable Player var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean setTarget(@Nullable LivingEntity var1, EntityTargetEvent.TargetReason var2, boolean var3);

    public boolean canAttack(LivingEntity var1);

    @Nullable
    public LivingEntity getTarget();

    default public void tickInitialPersistentAnger(Level level) {
        UUID target = this.getPersistentAngerTarget();
        if (target == null) {
            return;
        }
        Entity entity = ((ServerLevel)level).getEntity(target);
        if (entity != null) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.setTarget(mob, EntityTargetEvent.TargetReason.UNKNOWN, false);
                this.setLastHurtByMob(mob);
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.setTarget(player, EntityTargetEvent.TargetReason.UNKNOWN, false);
                this.setLastHurtByPlayer(player);
            }
        }
    }
}

