/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public record PositionMoveRotation(Vec3 position, Vec3 deltaMovement, float yRot, float xRot) {
    public static final StreamCodec<FriendlyByteBuf, PositionMoveRotation> STREAM_CODEC = StreamCodec.composite(Vec3.STREAM_CODEC, PositionMoveRotation::position, Vec3.STREAM_CODEC, PositionMoveRotation::deltaMovement, ByteBufCodecs.FLOAT, PositionMoveRotation::yRot, ByteBufCodecs.FLOAT, PositionMoveRotation::xRot, PositionMoveRotation::new);

    public static PositionMoveRotation of(Entity entity) {
        return new PositionMoveRotation(entity.position(), entity.getKnownMovement(), entity.getYRot(), entity.getXRot());
    }

    public static PositionMoveRotation ofEntityUsingLerpTarget(Entity entity) {
        return new PositionMoveRotation(new Vec3(entity.lerpTargetX(), entity.lerpTargetY(), entity.lerpTargetZ()), entity.getKnownMovement(), entity.getYRot(), entity.getXRot());
    }

    public static PositionMoveRotation of(TeleportTransition teleportTarget) {
        return new PositionMoveRotation(teleportTarget.position(), teleportTarget.deltaMovement(), teleportTarget.yRot(), teleportTarget.xRot());
    }

    public static PositionMoveRotation calculateAbsolute(PositionMoveRotation currentPos, PositionMoveRotation newPos, Set<Relative> flags) {
        double d = flags.contains((Object)Relative.X) ? currentPos.position.x : 0.0;
        double e = flags.contains((Object)Relative.Y) ? currentPos.position.y : 0.0;
        double f = flags.contains((Object)Relative.Z) ? currentPos.position.z : 0.0;
        float g = flags.contains((Object)Relative.Y_ROT) ? currentPos.yRot : 0.0f;
        float h = flags.contains((Object)Relative.X_ROT) ? currentPos.xRot : 0.0f;
        Vec3 vec3 = new Vec3(d + newPos.position.x, e + newPos.position.y, f + newPos.position.z);
        float i = g + newPos.yRot;
        float j = h + newPos.xRot;
        Vec3 vec32 = currentPos.deltaMovement;
        if (flags.contains((Object)Relative.ROTATE_DELTA)) {
            float k = currentPos.yRot - i;
            float l = currentPos.xRot - j;
            vec32 = vec32.xRot((float)Math.toRadians(l));
            vec32 = vec32.yRot((float)Math.toRadians(k));
        }
        Vec3 vec33 = new Vec3(PositionMoveRotation.calculateDelta(vec32.x, newPos.deltaMovement.x, flags, Relative.DELTA_X), PositionMoveRotation.calculateDelta(vec32.y, newPos.deltaMovement.y, flags, Relative.DELTA_Y), PositionMoveRotation.calculateDelta(vec32.z, newPos.deltaMovement.z, flags, Relative.DELTA_Z));
        return new PositionMoveRotation(vec3, vec33, i, j);
    }

    private static double calculateDelta(double delta, double value, Set<Relative> flags, Relative deltaFlag) {
        return flags.contains((Object)deltaFlag) ? delta + value : value;
    }
}

