/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import ca.spottedleaf.moonrise.common.set.OptimizedSmallEnumSet;
import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;

public class GoalSelector {
    private static final WrappedGoal NO_GOAL = new WrappedGoal(Integer.MAX_VALUE, new Goal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<Goal.Flag, WrappedGoal> lockedFlags = new EnumMap<Goal.Flag, WrappedGoal>(Goal.Flag.class);
    private final Set<WrappedGoal> availableGoals = new ObjectLinkedOpenHashSet();
    private static final Goal.Flag[] GOAL_FLAG_VALUES = Goal.Flag.values();
    private final OptimizedSmallEnumSet<Goal.Flag> goalTypes = new OptimizedSmallEnumSet<Goal.Flag>(Goal.Flag.class);
    private int curRate;

    public void addGoal(int priority, Goal goal) {
        this.availableGoals.add(new WrappedGoal(priority, goal));
    }

    @VisibleForTesting
    public void removeAllGoals(Predicate<Goal> predicate) {
        this.availableGoals.removeIf(goal -> predicate.test(goal.getGoal()));
    }

    public boolean inactiveTick() {
        ++this.curRate;
        return this.curRate % 3 == 0;
    }

    public boolean hasTasks() {
        for (WrappedGoal task : this.availableGoals) {
            if (!task.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void removeGoal(Goal goal) {
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (wrappedGoal.getGoal() != goal || !wrappedGoal.isRunning()) continue;
            wrappedGoal.stop();
        }
        this.availableGoals.removeIf(wrappedGoalx -> wrappedGoalx.getGoal() == goal);
    }

    private static boolean goalContainsAnyFlags(WrappedGoal goal, OptimizedSmallEnumSet<Goal.Flag> controls) {
        return goal.getFlags().hasCommonElements(controls);
    }

    private static boolean goalCanBeReplacedForAllFlags(WrappedGoal goal, Map<Goal.Flag, WrappedGoal> goalsByControl) {
        long flagIterator = goal.getFlags().getBackingSet();
        int wrappedGoalSize = goal.getFlags().size();
        for (int i = 0; i < wrappedGoalSize; ++i) {
            Goal.Flag flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
            flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
            if (goalsByControl.getOrDefault((Object)flag, NO_GOAL).canBeReplacedBy(goal)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("goalCleanup");
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (!wrappedGoal.isRunning() || !GoalSelector.goalContainsAnyFlags(wrappedGoal, this.goalTypes) && wrappedGoal.canContinueToUse()) continue;
            wrappedGoal.stop();
        }
        this.lockedFlags.entrySet().removeIf(entry -> !((WrappedGoal)entry.getValue()).isRunning());
        profilerFiller.pop();
        profilerFiller.push("goalUpdate");
        for (WrappedGoal wrappedGoal2 : this.availableGoals) {
            if (wrappedGoal2.isRunning() || GoalSelector.goalContainsAnyFlags(wrappedGoal2, this.goalTypes) || !GoalSelector.goalCanBeReplacedForAllFlags(wrappedGoal2, this.lockedFlags) || !wrappedGoal2.canUse()) continue;
            long flagIterator = wrappedGoal2.getFlags().getBackingSet();
            int wrappedGoalSize = wrappedGoal2.getFlags().size();
            for (int i = 0; i < wrappedGoalSize; ++i) {
                Goal.Flag flag = GOAL_FLAG_VALUES[Long.numberOfTrailingZeros(flagIterator)];
                flagIterator ^= IntegerUtil.getTrailingBit(flagIterator);
                WrappedGoal wrappedGoal3 = this.lockedFlags.getOrDefault((Object)flag, NO_GOAL);
                wrappedGoal3.stop();
                this.lockedFlags.put(flag, wrappedGoal2);
            }
            wrappedGoal2.start();
        }
        profilerFiller.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean tickAll) {
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("goalTick");
        for (WrappedGoal wrappedGoal : this.availableGoals) {
            if (!wrappedGoal.isRunning() || !tickAll && !wrappedGoal.requiresUpdateEveryTick()) continue;
            wrappedGoal.tick();
        }
        profilerFiller.pop();
    }

    public Set<WrappedGoal> getAvailableGoals() {
        return this.availableGoals;
    }

    public void disableControlFlag(Goal.Flag control) {
        this.goalTypes.addUnchecked(control);
    }

    public void enableControlFlag(Goal.Flag control) {
        this.goalTypes.removeUnchecked(control);
    }

    public void setControlFlag(Goal.Flag control, boolean enabled) {
        if (enabled) {
            this.enableControlFlag(control);
        } else {
            this.disableControlFlag(control);
        }
    }
}

