/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class AxolotlAttackablesSensor
extends NearestVisibleLivingEntitySensor {
    public static final float TARGET_DETECTION_DISTANCE = 8.0f;

    @Override
    @Override
    protected boolean isMatchingEntity(ServerLevel world, LivingEntity entity, LivingEntity target) {
        return this.isClose(entity, target) && target.isInWaterOrBubble() && (this.isHostileTarget(target) || this.isHuntTarget(entity, target)) && Sensor.isEntityAttackable(world, entity, target);
    }

    private boolean isHuntTarget(LivingEntity axolotl, LivingEntity target) {
        return !axolotl.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && target.getType().is(EntityTypeTags.AXOLOTL_HUNT_TARGETS);
    }

    private boolean isHostileTarget(LivingEntity axolotl) {
        return axolotl.getType().is(EntityTypeTags.AXOLOTL_ALWAYS_HOSTILES);
    }

    private boolean isClose(LivingEntity axolotl, LivingEntity target) {
        return target.distanceToSqr(axolotl) <= 64.0;
    }

    @Override
    @Override
    protected MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_ATTACKABLE;
    }
}

