/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class TargetingConditions {
    public static final TargetingConditions DEFAULT = TargetingConditions.forCombat();
    private static final double MIN_VISIBILITY_DISTANCE_FOR_INVISIBLE_TARGET = 2.0;
    private final boolean isCombat;
    private double range = -1.0;
    private boolean checkLineOfSight = true;
    private boolean testInvisible = true;
    @Nullable
    private Selector selector;

    private TargetingConditions(boolean attackable) {
        this.isCombat = attackable;
    }

    public static TargetingConditions forCombat() {
        return new TargetingConditions(true);
    }

    public static TargetingConditions forNonCombat() {
        return new TargetingConditions(false);
    }

    public TargetingConditions copy() {
        TargetingConditions targetingConditions = this.isCombat ? TargetingConditions.forCombat() : TargetingConditions.forNonCombat();
        targetingConditions.range = this.range;
        targetingConditions.checkLineOfSight = this.checkLineOfSight;
        targetingConditions.testInvisible = this.testInvisible;
        targetingConditions.selector = this.selector;
        return targetingConditions;
    }

    public TargetingConditions range(double baseMaxDistance) {
        this.range = baseMaxDistance;
        return this;
    }

    public TargetingConditions ignoreLineOfSight() {
        this.checkLineOfSight = false;
        return this;
    }

    public TargetingConditions ignoreInvisibilityTesting() {
        this.testInvisible = false;
        return this;
    }

    public TargetingConditions selector(@Nullable Selector predicate) {
        this.selector = predicate;
        return this;
    }

    public boolean test(ServerLevel world, @Nullable LivingEntity tester, LivingEntity target) {
        if (tester == target) {
            return false;
        }
        if (!target.canBeSeenByAnyone()) {
            return false;
        }
        if (this.selector != null && !this.selector.test(target, world)) {
            return false;
        }
        if (tester == null) {
            if (this.isCombat && (!target.canBeSeenAsEnemy() || world.getDifficulty() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob mob;
            if (this.isCombat && (!tester.canAttack(target) || !tester.canAttackType(target.getType()) || tester.isAlliedTo(target))) {
                return false;
            }
            if (this.range > 0.0) {
                double d = this.testInvisible ? target.getVisibilityPercent(tester) : 1.0;
                double e = Math.max(this.range * d, 2.0);
                double f = tester.distanceToSqr(target.getX(), target.getY(), target.getZ());
                if (f > e * e) {
                    return false;
                }
            }
            if (this.checkLineOfSight && tester instanceof Mob && !(mob = (Mob)tester).getSensing().hasLineOfSight(target)) {
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface Selector {
        public boolean test(LivingEntity var1, ServerLevel var2);
    }
}

