/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class VillageSiege
implements CustomSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int zombiesToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    @Override
    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!world.isDay() && spawnMonsters) {
            float f = world.getTimeOfDay(0.0f);
            if ((double)f == 0.5) {
                State state = this.siegeState = world.random.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.siegeState == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.hasSetupSiege) {
                if (!this.tryToSetupSiege(world)) {
                    return 0;
                }
                this.hasSetupSiege = true;
            }
            if (this.nextSpawnTime > 0) {
                --this.nextSpawnTime;
                return 0;
            }
            this.nextSpawnTime = 2;
            if (this.zombiesToSpawn > 0) {
                this.trySpawn(world);
                --this.zombiesToSpawn;
            } else {
                this.siegeState = State.SIEGE_DONE;
            }
            return 1;
        }
        this.siegeState = State.SIEGE_DONE;
        this.hasSetupSiege = false;
        return 0;
    }

    private boolean tryToSetupSiege(ServerLevel world) {
        for (Player player : world.players()) {
            BlockPos blockposition;
            if (player.isSpectator() || !world.isVillage(blockposition = player.blockPosition()) || world.getBiome(blockposition).is(BiomeTags.WITHOUT_ZOMBIE_SIEGES)) continue;
            for (int i = 0; i < 10; ++i) {
                float f = world.random.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = blockposition.getX() + Mth.floor(Mth.cos(f) * 32.0f);
                this.spawnY = blockposition.getY();
                this.spawnZ = blockposition.getZ() + Mth.floor(Mth.sin(f) * 32.0f);
                if (this.findRandomSpawnPos(world, new BlockPos(this.spawnX, this.spawnY, this.spawnZ)) == null) continue;
                this.nextSpawnTime = 0;
                this.zombiesToSpawn = 20;
                break;
            }
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel world) {
        Vec3 vec3d = this.findRandomSpawnPos(world, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3d != null) {
            Zombie entityzombie;
            try {
                entityzombie = new Zombie(world);
                entityzombie.finalizeSpawn(world, world.getCurrentDifficultyAt(entityzombie.blockPosition()), EntitySpawnReason.EVENT, null);
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to create zombie for village siege at {}", (Object)vec3d, (Object)exception);
                ServerInternalException.reportInternalException((Throwable)exception);
                return;
            }
            entityzombie.moveTo(vec3d.x, vec3d.y, vec3d.z, world.random.nextFloat() * 360.0f, 0.0f);
            world.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.VILLAGE_INVASION);
        }
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel world, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.getX() + world.random.nextInt(16) - 8;
            BlockPos blockposition1 = new BlockPos(j, l = world.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = pos.getZ() + world.random.nextInt(16) - 8), k);
            if (!world.isVillage(blockposition1) || !Monster.checkMonsterSpawnRules(EntityType.ZOMBIE, world, EntitySpawnReason.EVENT, blockposition1, world.random)) continue;
            return Vec3.atBottomCenterOf(blockposition1);
        }
        return null;
    }

    private static enum State {
        SIEGE_CAN_ACTIVATE,
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

