/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EndCrystal
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_BEAM_TARGET = SynchedEntityData.defineId(EndCrystal.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> DATA_SHOW_BOTTOM = SynchedEntityData.defineId(EndCrystal.class, EntityDataSerializers.BOOLEAN);
    public int time;
    public boolean generatedByDragonFight = false;

    public EndCrystal(EntityType<? extends EndCrystal> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
        this.time = this.random.nextInt(100000);
    }

    public EndCrystal(Level world, double x, double y, double z) {
        this((EntityType<? extends EndCrystal>)EntityType.END_CRYSTAL, world);
        this.setPos(x, y, z);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_BEAM_TARGET, Optional.empty());
        builder.define(DATA_SHOW_BOTTOM, true);
    }

    @Override
    public void tick() {
        ++this.time;
        this.applyEffectsFromBlocks();
        this.handlePortal();
        if (this.level() instanceof ServerLevel) {
            BlockPos blockposition = this.blockPosition();
            if (((ServerLevel)this.level()).getDragonFight() != null && this.level().getBlockState(blockposition).isAir() && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                this.level().setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level(), blockposition));
            }
            if (this.level().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.isInvulnerable() && (!Objects.equals(((ServerLevel)this.level()).uuid, this.getOriginWorld()) || ((ServerLevel)this.level()).getDragonFight() == null || ((ServerLevel)this.level()).getDragonFight().respawnStage == null || ((ServerLevel)this.level()).getDragonFight().respawnStage.ordinal() > DragonRespawnAnimation.SUMMONING_DRAGON.ordinal())) {
                this.setInvulnerable(false);
                this.setBeamTarget(null);
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (this.getBeamTarget() != null) {
            nbt.put("beam_target", NbtUtils.writeBlockPos(this.getBeamTarget()));
        }
        nbt.putBoolean("ShowBottom", this.showsBottom());
        if (this.generatedByDragonFight) {
            nbt.putBoolean("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        NbtUtils.readBlockPos(nbt, "beam_target").ifPresent(this::setBeamTarget);
        if (nbt.contains("ShowBottom", 1)) {
            this.setShowBottom(nbt.getBoolean("ShowBottom"));
        }
        if (nbt.contains("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.getBoolean("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public final boolean hurtClient(DamageSource source) {
        return this.isInvulnerableToBase(source) ? false : !(source.getEntity() instanceof EnderDragon);
    }

    @Override
    public final boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (this.isInvulnerableToBase(source)) {
            return false;
        }
        if (source.getEntity() instanceof EnderDragon) {
            return false;
        }
        if (!this.isRemoved()) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            if (!source.is(DamageTypeTags.IS_EXPLOSION)) {
                DamageSource damagesource1 = source.getEntity() != null ? this.damageSources().explosion(this, source.getEntity()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    return false;
                }
                this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.EXPLODE);
                world.explode(this, damagesource1, null, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.BLOCK);
            } else {
                this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            }
            this.onDestroyedBy(world, source);
        }
        return true;
    }

    @Override
    public void kill(ServerLevel world) {
        this.onDestroyedBy(world, this.damageSources().generic());
        super.kill(world);
    }

    private void onDestroyedBy(ServerLevel world, DamageSource source) {
        EndDragonFight enderdragonbattle = world.getDragonFight();
        if (enderdragonbattle != null) {
            enderdragonbattle.onCrystalDestroyed(this, source);
        }
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.getEntityData().set(DATA_BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return this.getEntityData().get(DATA_BEAM_TARGET).orElse(null);
    }

    public void setShowBottom(boolean showBottom) {
        this.getEntityData().set(DATA_SHOW_BOTTOM, showBottom);
    }

    public boolean showsBottom() {
        return this.getEntityData().get(DATA_SHOW_BOTTOM);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        return super.shouldRenderAtSqrDistance(distance) || this.getBeamTarget() != null;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.END_CRYSTAL);
    }
}

