/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractDragonPhaseInstance
implements DragonPhaseInstance {
    protected final EnderDragon dragon;

    public AbstractDragonPhaseInstance(EnderDragon dragon) {
        this.dragon = dragon;
    }

    @Override
    @Override
    public boolean isSitting() {
        return false;
    }

    @Override
    @Override
    public void doClientTick() {
    }

    @Override
    @Override
    public void doServerTick(ServerLevel world) {
    }

    @Override
    @Override
    public void onCrystalDestroyed(EndCrystal crystal, BlockPos pos, DamageSource source, @Nullable Player player) {
    }

    @Override
    @Override
    public void begin() {
    }

    @Override
    @Override
    public void end() {
    }

    @Override
    @Override
    public float getFlySpeed() {
        return 0.6f;
    }

    @Override
    @Nullable
    @Override
    public Vec3 getFlyTargetLocation() {
        return null;
    }

    @Override
    @Override
    public float onHurt(DamageSource damageSource, float damage) {
        return damage;
    }

    @Override
    @Override
    public float getTurnSpeed() {
        float f = (float)this.dragon.getDeltaMovement().horizontalDistance() + 1.0f;
        float g = Math.min(f, 40.0f);
        return 0.7f / g / f;
    }
}

