/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int checkInterval;
    protected BlockPos pos;

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> type, Level world) {
        super(type, world);
        this.checkInterval = this.getId() % this.level().spigotConfig.hangingTickFrequency;
    }

    protected BlockAttachedEntity(EntityType<? extends BlockAttachedEntity> type, Level world, BlockPos attachedBlockPos) {
        this(type, world);
        this.pos = attachedBlockPos;
    }

    protected abstract void recalculateBoundingBox();

    @Override
    public void tick() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.checkBelowWorld();
            if (this.checkInterval++ == this.level().spigotConfig.hangingTickFrequency) {
                this.checkInterval = 0;
                if (!this.isRemoved() && !this.survives()) {
                    BlockState material = this.level().getBlockState(this.blockPosition());
                    HangingBreakEvent.RemoveCause cause = !material.isAir() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.isRemoved() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.dropItem(worldserver, null);
                }
            }
        }
    }

    public abstract boolean survives();

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean skipAttackInteraction(Entity attacker) {
        if (attacker instanceof Player) {
            Player entityhuman = (Player)attacker;
            return !this.level().mayInteract(entityhuman, this.pos) ? true : this.hurtOrSimulate(this.damageSources().playerAttack(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean hurtClient(DamageSource source) {
        return !this.isInvulnerableToBase(source);
    }

    @Override
    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (this.isInvulnerableToBase(source)) {
            return false;
        }
        if (!world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && source.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.isRemoved()) {
            Entity damager;
            Entity entity = damager = !source.isDirect() && source.getEntity() != null ? source.getEntity() : source.getDirectEntity();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), source.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), source.is(DamageTypeTags.IS_EXPLOSION) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.isRemoved() || event.isCancelled()) {
                return true;
            }
            this.kill(world);
            this.markHurt();
            this.dropItem(world, source.getEntity());
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return explosion.shouldAffectBlocklikeEntities() ? super.ignoreExplosion(explosion) : true;
    }

    @Override
    public void move(MoverType type, Vec3 movement) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (!this.isRemoved() && movement.lengthSqr() > 0.0) {
                HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (this.isRemoved() || event.isCancelled()) {
                    return;
                }
                this.kill(worldserver);
                this.dropItem(worldserver, null);
            }
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbttagcompound, boolean includeAll) {
        if (includeAll) {
            this.addAdditionalSaveData(nbttagcompound);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        BlockPos blockposition = this.getPos();
        nbt.putInt("TileX", blockposition.getX());
        nbt.putInt("TileY", blockposition.getY());
        nbt.putInt("TileZ", blockposition.getZ());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        BlockPos blockposition = new BlockPos(nbt.getInt("TileX"), nbt.getInt("TileY"), nbt.getInt("TileZ"));
        if (!blockposition.closerThan(this.blockPosition(), 16.0)) {
            LOGGER.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        } else {
            this.pos = blockposition;
        }
    }

    public abstract void dropItem(ServerLevel var1, @Nullable Entity var2);

    @Override
    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    @Override
    public void setPos(double x, double y, double z) {
        this.pos = BlockPos.containing(x, y, z);
        this.recalculateBoundingBox();
        this.hasImpulse = true;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void thunderHit(ServerLevel world, LightningBolt lightning) {
    }

    @Override
    public void refreshDimensions() {
    }
}

