/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;

public class StartHuntingHoglin {
    public static OneShot<Piglin> create() {
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN), context.absent(MemoryModuleType.ANGRY_AT), context.absent(MemoryModuleType.HUNTED_RECENTLY), context.registered(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS)).apply((Applicative)context, (nearestVisibleHuntableHoglin, angryAt, huntedRecently, nearestVisibleAdultPiglins) -> (world, entity, time) -> {
            if (entity.isBaby() || context.tryGet(nearestVisibleAdultPiglins).map(piglin -> piglin.stream().anyMatch(StartHuntingHoglin::hasHuntedRecently)).isPresent()) {
                return false;
            }
            Hoglin hoglin = (Hoglin)context.get(nearestVisibleHuntableHoglin);
            PiglinAi.setAngerTarget(world, entity, hoglin);
            PiglinAi.dontKillAnyMoreHoglinsForAWhile(entity);
            PiglinAi.broadcastAngerTarget(world, entity, hoglin);
            context.tryGet(nearestVisibleAdultPiglins).ifPresent(piglin -> piglin.forEach(PiglinAi::dontKillAnyMoreHoglinsForAWhile));
            return true;
        }));
    }

    private static boolean hasHuntedRecently(AbstractPiglin piglin) {
        return piglin.getBrain().hasMemoryValue(MemoryModuleType.HUNTED_RECENTLY);
    }
}

