/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class WanderingTraderSpawner
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingTraderSpawner(ServerLevelData properties) {
        this.serverLevelData = properties;
        this.tickDelay = Integer.MIN_VALUE;
    }

    @Override
    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (this.tickDelay == Integer.MIN_VALUE) {
            this.tickDelay = world.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
            this.spawnDelay = world.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
            this.spawnChance = world.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
        }
        if (!world.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return 0;
        }
        if (this.tickDelay - 1 > 0) {
            --this.tickDelay;
            return 0;
        }
        this.tickDelay = world.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
        this.spawnDelay -= world.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = world.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
        if (!world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.clamp(i + world.paperConfig().entities.spawning.wanderingTrader.spawnChanceFailureIncrement, world.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin, world.paperConfig().entities.spawning.wanderingTrader.spawnChanceMax);
        if (this.random.nextInt(100) > i) {
            return 0;
        }
        if (this.spawn(world)) {
            this.spawnChance = world.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel world) {
        ServerPlayer entityplayer = world.getRandomPlayer();
        if (entityplayer == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPos blockposition = entityplayer.blockPosition();
        boolean flag = true;
        PoiManager villageplace = world.getPoiManager();
        Optional<BlockPos> optional = villageplace.find(holder -> holder.is(PoiTypes.MEETING), blockposition1 -> true, blockposition, 48, PoiManager.Occupancy.ANY);
        BlockPos blockposition12 = optional.orElse(blockposition);
        BlockPos blockposition2 = this.findSpawnPositionNear(world, blockposition12, 48);
        if (blockposition2 != null && this.hasEnoughSpace(world, blockposition2)) {
            if (world.getBiome(blockposition2).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            WanderingTrader entityvillagertrader = EntityType.WANDERING_TRADER.spawn(world, trader -> trader.setDespawnDelay(48000), blockposition2, EntitySpawnReason.EVENT, false, false, CreatureSpawnEvent.SpawnReason.NATURAL);
            if (entityvillagertrader != null) {
                for (int i = 0; i < 2; ++i) {
                    this.tryToSpawnLlamaFor(world, entityvillagertrader, 4);
                }
                this.serverLevelData.setWanderingTraderId(entityvillagertrader.getUUID());
                entityvillagertrader.setWanderTarget(blockposition12);
                entityvillagertrader.restrictTo(blockposition12, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel world, WanderingTrader wanderingTrader, int range) {
        TraderLlama entityllamatrader;
        BlockPos blockposition = this.findSpawnPositionNear(world, wanderingTrader.blockPosition(), range);
        if (blockposition != null && (entityllamatrader = EntityType.TRADER_LLAMA.spawn(world, blockposition, EntitySpawnReason.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL)) != null) {
            entityllamatrader.setLeashedTo(wanderingTrader, true);
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader world, BlockPos pos, int range) {
        BlockPos blockposition1 = null;
        SpawnPlacementType spawnplacementtype = SpawnPlacements.getPlacementType(EntityType.WANDERING_TRADER);
        for (int j = 0; j < 10; ++j) {
            int l;
            int i1;
            int k = pos.getX() + this.random.nextInt(range * 2) - range;
            BlockPos blockposition2 = new BlockPos(k, i1 = world.getHeight(Heightmap.Types.WORLD_SURFACE, k, l = pos.getZ() + this.random.nextInt(range * 2) - range), l);
            if (!spawnplacementtype.isSpawnPositionOk(world, blockposition2, EntityType.WANDERING_TRADER)) continue;
            blockposition1 = blockposition2;
            break;
        }
        return blockposition1;
    }

    private boolean hasEnoughSpace(BlockGetter world, BlockPos pos) {
        BlockPos blockposition1;
        Iterator<BlockPos> iterator = BlockPos.betweenClosed(pos, pos.offset(1, 2, 1)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (world.getBlockState(blockposition1 = iterator.next()).getCollisionShape(world, blockposition1).isEmpty());
        return false;
    }
}

