/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;

public class StackedContents<T> {
    public final Object2IntOpenHashMap<T> amounts = new Object2IntOpenHashMap();

    boolean hasAnyAmount(T input) {
        return this.amounts.getInt(input) > 0;
    }

    boolean hasAtLeast(T input, int minimum) {
        return this.amounts.getInt(input) >= minimum;
    }

    void take(T input, int count) {
        int i = this.amounts.addTo(input, -count);
        if (i < count) {
            throw new IllegalStateException("Took " + count + " items, but only had " + i);
        }
    }

    void put(T input, int count) {
        this.amounts.addTo(input, count);
    }

    public boolean tryPick(List<IngredientInfo<T>> ingredients, int quantity, @Nullable Output<T> itemCallback) {
        return new RecipePicker(ingredients).tryPick(quantity, itemCallback);
    }

    public int tryPickAll(List<IngredientInfo<T>> ingredients, int max, @Nullable Output<T> itemCallback) {
        return new RecipePicker(ingredients).tryPickAll(max, itemCallback);
    }

    public void clear() {
        this.amounts.clear();
    }

    public void account(T input, int count) {
        this.put(input, count);
    }

    class RecipePicker {
        private final List<IngredientInfo<T>> ingredients;
        private final int ingredientCount;
        private final List<T> items;
        private final int itemCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public RecipePicker(List<IngredientInfo<T>> ingredients) {
            this.ingredients = ingredients;
            this.ingredientCount = this.ingredients.size();
            this.items = this.getUniqueAvailableIngredientItems();
            this.itemCount = this.items.size();
            this.data = new BitSet(this.visitedIngredientCount() + this.visitedItemCount() + this.satisfiedCount() + this.connectionCount() + this.residualCount());
            this.setInitialConnections();
        }

        private void setInitialConnections() {
            for (int i = 0; i < this.ingredientCount; ++i) {
                List list = this.ingredients.get(i).allowedItems();
                for (int j = 0; j < this.itemCount; ++j) {
                    if (!list.contains(this.items.get(j))) continue;
                    this.setConnection(j, i);
                }
            }
        }

        public boolean tryPick(int quantity, @Nullable Output<T> itemCallback) {
            if (quantity <= 0) {
                return true;
            }
            int i = 0;
            block0: while (true) {
                IntList intList;
                if ((intList = this.tryAssigningNewItem(quantity)) == null) {
                    boolean bl = i == this.ingredientCount;
                    boolean bl2 = bl && itemCallback != null;
                    this.clearAllVisited();
                    this.clearSatisfied();
                    block1: for (int q = 0; q < this.ingredientCount; ++q) {
                        for (int r = 0; r < this.itemCount; ++r) {
                            if (!this.isAssigned(r, q)) continue;
                            this.unassign(r, q);
                            StackedContents.this.put(this.items.get(r), quantity);
                            if (!bl2) continue block1;
                            itemCallback.accept(this.items.get(r));
                            continue block1;
                        }
                    }
                    assert (this.data.get(this.residualOffset(), this.residualOffset() + this.residualCount()).isEmpty());
                    return bl;
                }
                int j = intList.getInt(0);
                StackedContents.this.take(this.items.get(j), quantity);
                int k = intList.size() - 1;
                this.setSatisfied(intList.getInt(k));
                ++i;
                int l = 0;
                while (true) {
                    if (l >= intList.size() - 1) continue block0;
                    if (RecipePicker.isPathIndexItem(l)) {
                        int m = intList.getInt(l);
                        int n = intList.getInt(l + 1);
                        this.assign(m, n);
                    } else {
                        int o = intList.getInt(l + 1);
                        int p = intList.getInt(l);
                        this.unassign(o, p);
                    }
                    ++l;
                }
                break;
            }
        }

        private static boolean isPathIndexItem(int index) {
            return (index & 1) == 0;
        }

        private List<T> getUniqueAvailableIngredientItems() {
            ReferenceOpenHashSet set = new ReferenceOpenHashSet();
            for (IngredientInfo ingredientInfo : this.ingredients) {
                set.addAll(ingredientInfo.allowedItems());
            }
            set.removeIf(item -> !StackedContents.this.hasAnyAmount(item));
            return List.copyOf(set);
        }

        @Nullable
        private IntList tryAssigningNewItem(int min) {
            this.clearAllVisited();
            for (int i = 0; i < this.itemCount; ++i) {
                IntList intList;
                if (!StackedContents.this.hasAtLeast(this.items.get(i), min) || (intList = this.findNewItemAssignmentPath(i)) == null) continue;
                return intList;
            }
            return null;
        }

        @Nullable
        private IntList findNewItemAssignmentPath(int itemIndex) {
            this.path.clear();
            this.visitItem(itemIndex);
            this.path.add(itemIndex);
            while (!this.path.isEmpty()) {
                int n;
                int i = this.path.size();
                if (RecipePicker.isPathIndexItem(i - 1)) {
                    int j = this.path.getInt(i - 1);
                    for (int k = 0; k < this.ingredientCount; ++k) {
                        if (this.hasVisitedIngredient(k) || !this.hasConnection(j, k) || this.isAssigned(j, k)) continue;
                        this.visitIngredient(k);
                        this.path.add(k);
                        break;
                    }
                } else {
                    int l = this.path.getInt(i - 1);
                    if (!this.isSatisfied(l)) {
                        return this.path;
                    }
                    for (int m = 0; m < this.itemCount; ++m) {
                        if (this.hasVisitedItem(m) || !this.isAssigned(m, l)) continue;
                        assert (this.hasConnection(m, l));
                        this.visitItem(m);
                        this.path.add(m);
                        break;
                    }
                }
                if ((n = this.path.size()) != i) continue;
                this.path.removeInt(n - 1);
            }
            return null;
        }

        private int visitedIngredientOffset() {
            return 0;
        }

        private int visitedIngredientCount() {
            return this.ingredientCount;
        }

        private int visitedItemOffset() {
            return this.visitedIngredientOffset() + this.visitedIngredientCount();
        }

        private int visitedItemCount() {
            return this.itemCount;
        }

        private int satisfiedOffset() {
            return this.visitedItemOffset() + this.visitedItemCount();
        }

        private int satisfiedCount() {
            return this.ingredientCount;
        }

        private int connectionOffset() {
            return this.satisfiedOffset() + this.satisfiedCount();
        }

        private int connectionCount() {
            return this.ingredientCount * this.itemCount;
        }

        private int residualOffset() {
            return this.connectionOffset() + this.connectionCount();
        }

        private int residualCount() {
            return this.ingredientCount * this.itemCount;
        }

        private boolean isSatisfied(int itemId) {
            return this.data.get(this.getSatisfiedIndex(itemId));
        }

        private void setSatisfied(int itemId) {
            this.data.set(this.getSatisfiedIndex(itemId));
        }

        private int getSatisfiedIndex(int itemId) {
            assert (itemId >= 0 && itemId < this.ingredientCount);
            return this.satisfiedOffset() + itemId;
        }

        private void clearSatisfied() {
            this.clearRange(this.satisfiedOffset(), this.satisfiedCount());
        }

        private void setConnection(int itemIndex, int ingredientIndex) {
            this.data.set(this.getConnectionIndex(itemIndex, ingredientIndex));
        }

        private boolean hasConnection(int itemIndex, int ingredientIndex) {
            return this.data.get(this.getConnectionIndex(itemIndex, ingredientIndex));
        }

        private int getConnectionIndex(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.itemCount);
            assert (ingredientIndex >= 0 && ingredientIndex < this.ingredientCount);
            return this.connectionOffset() + itemIndex * this.ingredientCount + ingredientIndex;
        }

        private boolean isAssigned(int itemIndex, int ingredientIndex) {
            return this.data.get(this.getResidualIndex(itemIndex, ingredientIndex));
        }

        private void assign(int itemIndex, int ingredientIndex) {
            int i = this.getResidualIndex(itemIndex, ingredientIndex);
            assert (!this.data.get(i));
            this.data.set(i);
        }

        private void unassign(int itemIndex, int ingredientIndex) {
            int i = this.getResidualIndex(itemIndex, ingredientIndex);
            assert (this.data.get(i));
            this.data.clear(i);
        }

        private int getResidualIndex(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.itemCount);
            assert (ingredientIndex >= 0 && ingredientIndex < this.ingredientCount);
            return this.residualOffset() + itemIndex * this.ingredientCount + ingredientIndex;
        }

        private void visitIngredient(int index) {
            this.data.set(this.getVisitedIngredientIndex(index));
        }

        private boolean hasVisitedIngredient(int index) {
            return this.data.get(this.getVisitedIngredientIndex(index));
        }

        private int getVisitedIngredientIndex(int index) {
            assert (index >= 0 && index < this.ingredientCount);
            return this.visitedIngredientOffset() + index;
        }

        private void visitItem(int index) {
            this.data.set(this.getVisitiedItemIndex(index));
        }

        private boolean hasVisitedItem(int index) {
            return this.data.get(this.getVisitiedItemIndex(index));
        }

        private int getVisitiedItemIndex(int index) {
            assert (index >= 0 && index < this.itemCount);
            return this.visitedItemOffset() + index;
        }

        private void clearAllVisited() {
            this.clearRange(this.visitedIngredientOffset(), this.visitedIngredientCount());
            this.clearRange(this.visitedItemOffset(), this.visitedItemCount());
        }

        private void clearRange(int start, int offset) {
            this.data.clear(start, start + offset);
        }

        public int tryPickAll(int max, @Nullable Output<T> itemCallback) {
            int i = 0;
            int j = Math.min(max, this.getMinIngredientCount()) + 1;
            while (true) {
                int k;
                if (this.tryPick(k = (i + j) / 2, null)) {
                    if (j - i <= 1) {
                        if (k > 0) {
                            this.tryPick(k, itemCallback);
                        }
                        return k;
                    }
                    i = k;
                    continue;
                }
                j = k;
            }
        }

        private int getMinIngredientCount() {
            int i = Integer.MAX_VALUE;
            for (IngredientInfo ingredientInfo : this.ingredients) {
                int j = 0;
                for (Object object : ingredientInfo.allowedItems()) {
                    j = Math.max(j, StackedContents.this.amounts.getInt(object));
                }
                if (i <= 0) continue;
                i = Math.min(i, j);
            }
            return i;
        }
    }

    @FunctionalInterface
    public static interface Output<T> {
        public void accept(T var1);
    }

    public record IngredientInfo<T>(List<T> allowedItems, boolean isExact) {
        public IngredientInfo {
            if (allowedItems.isEmpty()) {
                throw new IllegalArgumentException("Ingredients can't be empty");
            }
        }
    }
}

