/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import io.papermc.paper.inventory.recipe.StackedContentsExtrasMap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;

public class StackedItemContents {
    private final StackedContents<ItemOrExact> raw = new StackedContents();
    @Nullable
    private StackedContentsExtrasMap extrasMap = null;

    public void accountSimpleStack(ItemStack item) {
        if (this.extrasMap != null && this.extrasMap.accountStack(item, Math.min(64, item.getCount()))) {
            return;
        }
        if (Inventory.isUsableForCrafting(item)) {
            this.accountStack(item);
        }
    }

    public void accountStack(ItemStack item) {
        this.accountStack(item, item.getMaxStackSize());
    }

    public void accountStack(ItemStack item, int maxCount) {
        if (!item.isEmpty()) {
            int i = Math.min(maxCount, item.getCount());
            if (this.extrasMap != null && !item.getComponentsPatch().isEmpty() && this.extrasMap.accountStack(item, i)) {
                return;
            }
            this.raw.account(new ItemOrExact.Item(item.getItemHolder()), i);
        }
    }

    public void initializeExtras(Recipe<?> recipe, @Nullable CraftingInput input) {
        if (this.extrasMap == null) {
            this.extrasMap = new StackedContentsExtrasMap(this.raw);
        }
        this.extrasMap.initialize(recipe);
        if (input != null) {
            this.extrasMap.accountInput(input);
        }
    }

    public void resetExtras() {
        if (this.extrasMap != null && !this.raw.amounts.isEmpty()) {
            this.extrasMap.resetExtras();
        }
    }

    public static StackedContents.IngredientInfo<ItemOrExact> convertIngredientContents(Stream<ItemOrExact> items, boolean isExact) {
        List<ItemOrExact> list = items.sorted(Comparator.comparingInt(item -> isExact ? ItemStack.hashItemAndComponents(((ItemOrExact.Exact)item).stack()) : BuiltInRegistries.ITEM.getId(((ItemOrExact.Item)item).item().value()))).toList();
        return new StackedContents.IngredientInfo<ItemOrExact>(list, isExact);
    }

    public boolean canCraft(Recipe<?> recipe, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        return this.canCraft(recipe, 1, itemCallback);
    }

    public boolean canCraft(Recipe<?> recipe, int quantity, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        PlacementInfo placementInfo = recipe.placementInfo();
        return !placementInfo.isImpossibleToPlace() && this.canCraft(placementInfo.unpackedIngredients(), quantity, itemCallback);
    }

    public boolean canCraft(List<StackedContents.IngredientInfo<ItemOrExact>> rawIngredients, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        return this.canCraft(rawIngredients, 1, itemCallback);
    }

    private boolean canCraft(List<StackedContents.IngredientInfo<ItemOrExact>> rawIngredients, int quantity, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        return this.raw.tryPick(rawIngredients, quantity, itemCallback);
    }

    public int getBiggestCraftableStack(Recipe<?> recipe, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        return this.getBiggestCraftableStack(recipe, Integer.MAX_VALUE, itemCallback);
    }

    public int getBiggestCraftableStack(Recipe<?> recipe, int max, @Nullable StackedContents.Output<ItemOrExact> itemCallback) {
        return this.raw.tryPickAll(recipe.placementInfo().unpackedIngredients(), max, itemCallback);
    }

    public void clear() {
        this.raw.clear();
    }
}

