/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.EnderDragonFireballHitEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class DragonFireball
extends AbstractHurtingProjectile {
    public static final float SPLASH_RANGE = 4.0f;

    public DragonFireball(EntityType<? extends DragonFireball> type, Level world) {
        super((EntityType<? extends AbstractHurtingProjectile>)type, world);
    }

    public DragonFireball(Level world, LivingEntity owner, Vec3 velocity) {
        super(EntityType.DRAGON_FIREBALL, owner, velocity, world);
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!(hitResult.getType() == HitResult.Type.ENTITY && this.ownedBy(((EntityHitResult)hitResult).getEntity()) || this.level().isClientSide)) {
            List<LivingEntity> list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud entityareaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                entityareaeffectcloud.setOwner((LivingEntity)entity);
            }
            entityareaeffectcloud.setParticle(ParticleTypes.DRAGON_BREATH);
            entityareaeffectcloud.setRadius(3.0f);
            entityareaeffectcloud.setDuration(600);
            entityareaeffectcloud.setRadiusPerTick((7.0f - entityareaeffectcloud.getRadius()) / (float)entityareaeffectcloud.getDuration());
            entityareaeffectcloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity entityliving : list) {
                    double d0 = this.distanceToSqr(entityliving);
                    if (!(d0 < 16.0)) continue;
                    entityareaeffectcloud.setPos(entityliving.getX(), entityliving.getY(), entityliving.getZ());
                    break;
                }
            }
            if (new EnderDragonFireballHitEvent((org.bukkit.entity.DragonFireball)this.getBukkitEntity(), (Collection)list.stream().map(LivingEntity::getBukkitLivingEntity).collect(Collectors.toList()), (org.bukkit.entity.AreaEffectCloud)entityareaeffectcloud.getBukkitEntity()).callEvent()) {
                this.level().levelEvent(2006, this.blockPosition(), this.isSilent() ? -1 : 1);
                this.level().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
            } else {
                entityareaeffectcloud.discard(null);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.DRAGON_BREATH;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

