/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class Projectile
extends Entity
implements TraceableEntity {
    @Nullable
    public UUID ownerUUID;
    @Nullable
    public Entity cachedOwner;
    public boolean leftOwner;
    public boolean hasBeenShot;
    @Nullable
    private Entity lastDeflectedBy;
    protected boolean hitCancelled = false;

    Projectile(EntityType<? extends Projectile> type, Level world) {
        super(type, world);
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.getUUID();
            this.cachedOwner = entity;
        } else {
            this.ownerUUID = null;
            this.cachedOwner = null;
            this.projectileSource = null;
        }
        this.refreshProjectileSource(false);
    }

    public void refreshProjectileSource(boolean fillCache) {
        CraftEntity craftEntity;
        if (fillCache) {
            this.getOwner();
        }
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved() && this.projectileSource == null && (craftEntity = this.cachedOwner.getBukkitEntity()) instanceof ProjectileSource) {
            ProjectileSource projSource;
            this.projectileSource = projSource = (ProjectileSource)craftEntity;
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            this.refreshProjectileSource(false);
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.findOwner(this.ownerUUID);
            this.refreshProjectileSource(false);
            return this.cachedOwner;
        }
        return null;
    }

    @Nullable
    protected Entity findOwner(UUID uuid) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return worldserver.getEntity(uuid);
        }
        return null;
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (this.ownerUUID != null) {
            nbt.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            nbt.putBoolean("LeftOwner", true);
        }
        nbt.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.hasUUID("Owner")) {
            this.setOwnerThroughUUID(nbt.getUUID("Owner"));
            if (this instanceof ThrownEnderpearl && this.level() != null && this.level().paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && this.level().paperConfig().misc.legacyEnderPearlBehavior) {
                this.ownerUUID = null;
            }
        }
        this.leftOwner = nbt.getBoolean("LeftOwner");
        this.hasBeenShot = nbt.getBoolean("HasBeenShot");
    }

    protected void setOwnerThroughUUID(UUID uuid) {
        if (this.ownerUUID != uuid) {
            this.ownerUUID = uuid;
            this.cachedOwner = this.findOwner(uuid);
        }
    }

    @Override
    public void restoreFrom(Entity original) {
        super.restoreFrom(original);
        if (original instanceof Projectile) {
            Projectile iprojectile = (Projectile)original;
            this.ownerUUID = iprojectile.ownerUUID;
            this.cachedOwner = iprojectile.cachedOwner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            AABB axisalignedbb = this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0);
            return entity.getRootVehicle().getSelfAndPassengers().filter(EntitySelector.CAN_BE_PICKED).noneMatch(entity1 -> axisalignedbb.intersects(entity1.getBoundingBox()));
        }
        return true;
    }

    public Vec3 getMovementToShoot(double x, double y, double z, float power, float uncertainty) {
        return new Vec3(x, y, z).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)uncertainty), this.random.triangle(0.0, 0.0172275 * (double)uncertainty), this.random.triangle(0.0, 0.0172275 * (double)uncertainty)).scale(power);
    }

    public void shoot(double x, double y, double z, float power, float uncertainty) {
        Vec3 vec3d = this.getMovementToShoot(x, y, z, power, uncertainty);
        this.setDeltaMovement(vec3d);
        this.hasImpulse = true;
        double d3 = vec3d.horizontalDistance();
        this.setYRot((float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2(vec3d.y, d3) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f5 = -Mth.sin(yaw * ((float)Math.PI / 180)) * Mth.cos(pitch * ((float)Math.PI / 180));
        float f6 = -Mth.sin((pitch + roll) * ((float)Math.PI / 180));
        float f7 = Mth.cos(yaw * ((float)Math.PI / 180)) * Mth.cos(pitch * ((float)Math.PI / 180));
        this.shoot(f5, f6, f7, speed, divergence);
        Vec3 vec3d = shooter.getKnownMovement();
        if (!shooter.level().paperConfig().misc.disableRelativeProjectileVelocity) {
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d.x, shooter.onGround() ? 0.0 : vec3d.y, vec3d.z));
        }
    }

    public static <T extends Projectile> T spawnProjectileFromRotation(ProjectileFactory<T> creator, ServerLevel world, ItemStack projectileStack, LivingEntity shooter, float roll, float power, float divergence) {
        return Projectile.spawnProjectileFromRotationDelayed(creator, world, projectileStack, shooter, roll, power, divergence).spawn();
    }

    public static <T extends Projectile> Delayed<T> spawnProjectileFromRotationDelayed(ProjectileFactory<T> creator, ServerLevel world, ItemStack projectileStack, LivingEntity shooter, float roll, float power, float divergence) {
        return Projectile.spawnProjectileDelayed(creator.create(world, shooter, projectileStack), world, projectileStack, iprojectile -> iprojectile.shootFromRotation(shooter, shooter.getXRot(), shooter.getYRot(), roll, power, divergence));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(ProjectileFactory<T> creator, ServerLevel world, ItemStack projectileStack, LivingEntity shooter, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return (T)Projectile.spawnProjectile(creator.create(world, shooter, projectileStack), world, projectileStack, iprojectile -> iprojectile.shoot(velocityX, velocityY, velocityZ, power, divergence));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(T projectile, ServerLevel world, ItemStack projectileStack, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return Projectile.spawnProjectileUsingShootDelayed(projectile, world, projectileStack, velocityX, velocityY, velocityZ, power, divergence).spawn();
    }

    public static <T extends Projectile> Delayed<T> spawnProjectileUsingShootDelayed(T projectile, ServerLevel world, ItemStack projectileStack, double velocityX, double velocityY, double velocityZ, float power, float divergence) {
        return Projectile.spawnProjectileDelayed(projectile, world, projectileStack, iprojectile -> projectile.shoot(velocityX, velocityY, velocityZ, power, divergence));
    }

    public static <T extends Projectile> T spawnProjectile(T projectile, ServerLevel world, ItemStack projectileStack) {
        return (T)Projectile.spawnProjectile(projectile, world, projectileStack, iprojectile -> {});
    }

    public static <T extends Projectile> T spawnProjectile(T projectile, ServerLevel world, ItemStack projectileStack, Consumer<T> beforeSpawn) {
        return Projectile.spawnProjectileDelayed(projectile, world, projectileStack, beforeSpawn).spawn();
    }

    public static <T extends Projectile> Delayed<T> spawnProjectileDelayed(T projectile, ServerLevel world, ItemStack projectileStack, Consumer<T> beforeSpawn) {
        beforeSpawn.accept(projectile);
        return new Delayed<T>(projectile, world, projectileStack);
    }

    public void applyOnProjectileSpawned(ServerLevel world, ItemStack projectileStack) {
        AbstractArrow entityarrow;
        ItemStack itemstack1;
        EnchantmentHelper.onProjectileSpawned(world, projectileStack, this, item -> {});
        Projectile projectile = this;
        if (projectile instanceof AbstractArrow && (itemstack1 = (entityarrow = (AbstractArrow)projectile).getWeaponItem()) != null && !itemstack1.isEmpty() && !projectileStack.getItem().equals(itemstack1.getItem())) {
            Objects.requireNonNull(entityarrow);
            EnchantmentHelper.onProjectileSpawned(world, itemstack1, this, entityarrow::onItemBreak);
        }
    }

    public ProjectileDeflection preHitTargetOrDeflectSelf(HitResult movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.getType() == HitResult.Type.BLOCK || !this.hitCancelled) {
            return this.hitTargetOrDeflectSelf(movingobjectposition);
        }
        return ProjectileDeflection.NONE;
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult hitResult) {
        ProjectileDeflection projectiledeflection1;
        BlockHitResult movingobjectpositionblock;
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            EntityHitResult movingobjectpositionentity = (EntityHitResult)hitResult;
            Entity entity = movingobjectpositionentity.getEntity();
            ProjectileDeflection projectiledeflection = entity.deflection(this);
            if (projectiledeflection != ProjectileDeflection.NONE) {
                if (entity != this.lastDeflectedBy && this.deflect(projectiledeflection, entity, this.getOwner(), false)) {
                    this.lastDeflectedBy = entity;
                }
                return projectiledeflection;
            }
        } else if (this.shouldBounceOnWorldBorder() && hitResult instanceof BlockHitResult && (movingobjectpositionblock = (BlockHitResult)hitResult).isWorldBorderHit() && this.deflect(projectiledeflection1 = ProjectileDeflection.REVERSE, null, this.getOwner(), false)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            return projectiledeflection1;
        }
        this.onHit(hitResult);
        return ProjectileDeflection.NONE;
    }

    protected boolean shouldBounceOnWorldBorder() {
        return false;
    }

    public boolean deflect(ProjectileDeflection deflection, @Nullable Entity deflector, @Nullable Entity owner, boolean fromAttack) {
        deflection.deflect(this, deflector, this.random);
        if (!this.level().isClientSide) {
            Projectile projectile = this;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                arrow.setOwner(owner, false);
            } else {
                this.setOwner(owner);
            }
            this.onDeflection(deflector, fromAttack);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity deflector, boolean fromAttack) {
    }

    protected void onItemBreak(Item item) {
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type movingobjectposition_enummovingobjecttype = hitResult.getType();
        if (movingobjectposition_enummovingobjecttype == HitResult.Type.ENTITY) {
            EntityHitResult movingobjectpositionentity = (EntityHitResult)hitResult;
            Entity entity = movingobjectpositionentity.getEntity();
            if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                Projectile iprojectile = (Projectile)entity;
                iprojectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(movingobjectpositionentity);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, hitResult.getLocation(), GameEvent.Context.of(this, null));
        } else if (movingobjectposition_enummovingobjecttype == HitResult.Type.BLOCK) {
            BlockHitResult movingobjectpositionblock = (BlockHitResult)hitResult;
            this.onHitBlock(movingobjectpositionblock);
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, blockposition, GameEvent.Context.of(this, this.level().getBlockState(blockposition)));
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (this.hitCancelled) {
            return;
        }
        BlockState iblockdata = this.level().getBlockState(blockHitResult.getBlockPos());
        iblockdata.onProjectileHit(this.level(), iblockdata, blockHitResult, this);
    }

    @Override
    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d3 = Math.sqrt(x * x + z * z);
            this.setXRot((float)(Mth.atan2(y, d3) * 57.2957763671875));
            this.setYRot((float)(Mth.atan2(x, z) * 57.2957763671875));
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            this.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    public boolean canHitEntity(Entity entity) {
        if (!entity.canBeHitByProjectile()) {
            return false;
        }
        Entity entity1 = this.getOwner();
        if (entity1 instanceof ServerPlayer && entity instanceof ServerPlayer) {
            org.bukkit.entity.Player collided = (org.bukkit.entity.Player)entity.getBukkitEntity();
            org.bukkit.entity.Player shooter = (org.bukkit.entity.Player)entity1.getBukkitEntity();
            if (!shooter.canSee(collided)) {
                return false;
            }
        }
        return entity1 == null || this.leftOwner || !entity1.isPassengerOfSameVehicle(entity);
    }

    protected void updateRotation() {
        Vec3 vec3d = this.getDeltaMovement();
        double d0 = vec3d.horizontalDistance();
        this.setXRot(Projectile.lerpRotation(this.xRotO, (float)(Mth.atan2(vec3d.y, d0) * 57.2957763671875)));
        this.setYRot(Projectile.lerpRotation(this.yRotO, (float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float prevRot, float newRot) {
        prevRot += (float)Math.round((newRot - prevRot) / 360.0f) * 360.0f;
        return Mth.lerp(0.2f, prevRot, newRot);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entityTrackerEntry, entity == null ? 0 : entity.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    @Override
    public boolean mayInteract(ServerLevel world, BlockPos pos) {
        Entity entity = this.getOwner();
        return entity instanceof Player ? entity.mayInteract(world, pos) : entity == null || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(ServerLevel world) {
        return this.getType().is(EntityTypeTags.IMPACT_PROJECTILES) && world.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity target, DamageSource source) {
        double d0 = this.getDeltaMovement().x;
        double d1 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    @Override
    public int getDimensionChangingDelay() {
        return 2;
    }

    @Override
    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (!this.isInvulnerableToBase(source)) {
            this.markHurt();
        }
        return false;
    }

    @FunctionalInterface
    public static interface ProjectileFactory<T extends Projectile> {
        public T create(ServerLevel var1, LivingEntity var2, ItemStack var3);
    }

    public record Delayed<T extends Projectile>(T projectile, ServerLevel world, ItemStack projectileStack) {
        public boolean attemptSpawn() {
            if (!this.world.addFreshEntity((Entity)this.projectile)) {
                return false;
            }
            ((Projectile)this.projectile).applyOnProjectileSpawned(this.world, this.projectileStack);
            return true;
        }

        public T spawn() {
            this.attemptSpawn();
            return this.projectile();
        }

        public boolean attemptSpawn(CreatureSpawnEvent.SpawnReason reason) {
            if (!this.world.addFreshEntity((Entity)this.projectile, reason)) {
                return false;
            }
            ((Projectile)this.projectile).applyOnProjectileSpawned(this.world, this.projectileStack);
            return true;
        }

        public T spawn(CreatureSpawnEvent.SpawnReason reason) {
            this.attemptSpawn(reason);
            return this.projectile();
        }
    }
}

