/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWindCharge
extends AbstractHurtingProjectile
implements ItemSupplier {
    public static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.empty(), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    public static final double JUMP_SCALE = 0.25;

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, Level world) {
        super((EntityType<? extends AbstractHurtingProjectile>)type, world);
        this.accelerationPower = 0.0;
    }

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, Level world, Entity owner, double x, double y, double z) {
        super(type, x, y, z, world);
        this.setOwner(owner);
        this.accelerationPower = 0.0;
    }

    AbstractWindCharge(EntityType<? extends AbstractWindCharge> type, double x, double y, double z, Vec3 velocity, Level world) {
        super(type, x, y, z, velocity, world);
        this.accelerationPower = 0.0;
    }

    @Override
    protected AABB makeBoundingBox() {
        float f = this.getType().getDimensions().width() / 2.0f;
        float f1 = this.getType().getDimensions().height();
        float f2 = 0.15f;
        return new AABB(this.position().x - (double)f, this.position().y - (double)0.15f, this.position().z - (double)f, this.position().x + (double)f, this.position().y - (double)0.15f + (double)f1, this.position().z + (double)f);
    }

    @Override
    public boolean canCollideWith(Entity other) {
        return other instanceof AbstractWindCharge ? false : super.canCollideWith(other);
    }

    @Override
    public boolean canHitEntity(Entity entity) {
        return entity instanceof AbstractWindCharge ? false : (entity.getType() == EntityType.END_CRYSTAL ? false : super.canHitEntity(entity));
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            DamageSource damagesource;
            LivingEntity entityliving1;
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = this.getOwner();
            LivingEntity entityliving = entity instanceof LivingEntity ? (entityliving1 = (LivingEntity)entity) : null;
            LivingEntity entityliving2 = entityliving;
            Entity entity1 = entityHitResult.getEntity();
            if (entityliving2 != null) {
                entityliving2.setLastHurtMob(entity1);
            }
            if (entity1.hurtServer(worldserver, damagesource = this.damageSources().windCharge(this, entityliving2), 1.0f) && entity1 instanceof LivingEntity) {
                LivingEntity entityliving3 = (LivingEntity)entity1;
                EnchantmentHelper.doPostAttackEffects(worldserver, entityliving3, damagesource);
            }
            this.explode(this.position());
        }
    }

    @Override
    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
    }

    public abstract void explode(Vec3 var1);

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            Vec3i baseblockposition = blockHitResult.getDirection().getUnitVec3i();
            Vec3 vec3d = Vec3.atLowerCornerOf(baseblockposition).multiply(0.25, 0.25, 0.25);
            Vec3 vec3d1 = blockHitResult.getLocation().add(vec3d);
            this.explode(vec3d1);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @javax.annotation.Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxY() + 30) {
            this.explode(this.position());
            this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
        } else {
            super.tick();
        }
    }
}

