/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = SpawnPlacements.getPlacementType(EntityType.RAVAGER);
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final Component OMINOUS_BANNER_PATTERN_NAME = Component.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.translatable("event.minecraft.raid");
    private static final Component RAID_BAR_VICTORY_COMPONENT = Component.translatable("event.minecraft.raid.victory.full");
    private static final Component RAID_BAR_DEFEAT_COMPONENT = Component.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, Raider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<Raider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPos center;
    private final ServerLevel level;
    private boolean started;
    private final int id;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    public final ServerBossEvent raidEvent;
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random;
    public final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos;
    private static final String PDC_NBT_KEY = "BukkitValues";
    private static final CraftPersistentDataTypeRegistry PDC_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(PDC_TYPE_REGISTRY);

    public Raid(int id, ServerLevel world, BlockPos pos) {
        this.raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
        this.random = RandomSource.create();
        this.waveSpawnPos = Optional.empty();
        this.id = id;
        this.level = world;
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = pos;
        this.numGroups = this.getNumGroups(world.getDifficulty());
        this.status = RaidStatus.ONGOING;
    }

    public Raid(ServerLevel world, CompoundTag nbt) {
        this.raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
        this.random = RandomSource.create();
        this.waveSpawnPos = Optional.empty();
        this.level = world;
        this.id = nbt.getInt("Id");
        this.started = nbt.getBoolean("Started");
        this.active = nbt.getBoolean("Active");
        this.ticksActive = nbt.getLong("TicksActive");
        this.raidOmenLevel = nbt.getInt("BadOmenLevel");
        this.groupsSpawned = nbt.getInt("GroupsSpawned");
        this.raidCooldownTicks = nbt.getInt("PreRaidTicks");
        this.postRaidTicks = nbt.getInt("PostRaidTicks");
        this.totalHealth = nbt.getFloat("TotalHealth");
        this.center = new BlockPos(nbt.getInt("CX"), nbt.getInt("CY"), nbt.getInt("CZ"));
        this.numGroups = nbt.getInt("NumGroups");
        this.status = RaidStatus.getByName(nbt.getString("Status"));
        this.heroesOfTheVillage.clear();
        if (nbt.contains("HeroesOfTheVillage", 9)) {
            ListTag nbttaglist = nbt.getList("HeroesOfTheVillage", 11);
            for (Tag nbtbase : nbttaglist) {
                this.heroesOfTheVillage.add(NbtUtils.loadUUID(nbtbase));
            }
        }
        if (nbt.contains(PDC_NBT_KEY, 10)) {
            this.persistentDataContainer.putAll(nbt.getCompound(PDC_NBT_KEY));
        }
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public boolean isInProgress() {
        return this.status == RaidStatus.ONGOING;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<Raider> getAllRaiders() {
        HashSet set = Sets.newHashSet();
        for (Set<Raider> set1 : this.groupRaiderMap.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return entityplayer -> {
            BlockPos blockposition = entityplayer.blockPosition();
            return entityplayer.isAlive() && this.level.getRaidAt(blockposition) == this;
        };
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet(this.raidEvent.getPlayers());
        List<ServerPlayer> list = this.level.getPlayers(this.validPlayer());
        for (ServerPlayer entityplayer : list) {
            if (set.contains(entityplayer)) continue;
            this.raidEvent.addPlayer(entityplayer);
        }
        for (ServerPlayer entityplayer : set) {
            if (list.contains(entityplayer)) continue;
            this.raidEvent.removePlayer(entityplayer);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int badOmenLevel) {
        this.raidOmenLevel = badOmenLevel;
    }

    public boolean absorbRaidOmen(ServerPlayer player) {
        MobEffectInstance mobeffect = player.getEffect(MobEffects.RAID_OMEN);
        if (mobeffect == null) {
            return false;
        }
        this.raidOmenLevel += mobeffect.getAmplifier() + 1;
        this.raidOmenLevel = Mth.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            player.awardStat(Stats.RAID_TRIGGER);
            CriteriaTriggers.RAID_OMEN.trigger(player);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = RaidStatus.STOPPED;
    }

    public void tick() {
        if (!this.isStopped()) {
            if (this.status == RaidStatus.ONGOING) {
                boolean flag1;
                boolean flag = this.active;
                this.active = this.level.hasChunkAt(this.center);
                if (this.level.getDifficulty() == Difficulty.PEACEFUL) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.stop();
                    return;
                }
                if (flag != this.active) {
                    this.raidEvent.setVisible(this.active);
                }
                if (!this.active) {
                    return;
                }
                if (!this.level.isVillage(this.center)) {
                    this.moveRaidCenterToNearbyVillageSection();
                }
                if (!this.level.isVillage(this.center)) {
                    if (this.groupsSpawned > 0) {
                        this.status = RaidStatus.LOSS;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.stop();
                    }
                }
                ++this.ticksActive;
                if (this.ticksActive >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.stop();
                    return;
                }
                int i = this.getTotalRaidersAlive();
                if (i == 0 && this.hasMoreWaves()) {
                    if (this.raidCooldownTicks > 0) {
                        boolean flag2;
                        flag1 = this.waveSpawnPos.isPresent();
                        boolean bl = flag2 = !flag1 && this.raidCooldownTicks % 5 == 0;
                        if (flag1 && !this.level.isPositionEntityTicking(this.waveSpawnPos.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            this.waveSpawnPos = this.getValidSpawnPos();
                        }
                        if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                            this.updatePlayers();
                        }
                        --this.raidCooldownTicks;
                        this.raidEvent.setProgress(Mth.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                    } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                        this.raidCooldownTicks = 300;
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                        return;
                    }
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers();
                    this.updateRaiders();
                    if (i > 0) {
                        if (i <= 2) {
                            this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(Component.translatable(RAIDERS_REMAINING, i)));
                        } else {
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                        }
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                }
                flag1 = false;
                int j = 0;
                while (this.shouldSpawnGroup()) {
                    BlockPos blockposition = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(20));
                    if (blockposition != null) {
                        this.started = true;
                        this.spawnGroup(blockposition);
                        if (!flag1) {
                            this.playSound(blockposition);
                            flag1 = true;
                        }
                    } else {
                        ++j;
                    }
                    if (j <= 5) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.stop();
                    break;
                }
                if (this.isStarted() && !this.hasMoreWaves() && i == 0) {
                    if (this.postRaidTicks < 40) {
                        ++this.postRaidTicks;
                    } else {
                        this.status = RaidStatus.VICTORY;
                        Iterator<UUID> iterator = this.heroesOfTheVillage.iterator();
                        ArrayList<Player> winners = new ArrayList<Player>();
                        while (iterator.hasNext()) {
                            UUID uuid = iterator.next();
                            Entity entity = this.level.getEntity(uuid);
                            if (!(entity instanceof LivingEntity)) continue;
                            LivingEntity entityliving = (LivingEntity)entity;
                            if (entity.isSpectator()) continue;
                            entityliving.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                            if (!(entityliving instanceof ServerPlayer)) continue;
                            ServerPlayer entityplayer = (ServerPlayer)entityliving;
                            entityplayer.awardStat(Stats.RAID_WIN);
                            CriteriaTriggers.RAID_WIN.trigger(entityplayer);
                            winners.add(entityplayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.setDirty();
            } else if (this.isOver()) {
                ++this.celebrationTicks;
                if (this.celebrationTicks >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers();
                    this.raidEvent.setVisible(true);
                    if (this.isVictory()) {
                        this.raidEvent.setProgress(0.0f);
                        this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                    } else {
                        this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection() {
        Stream<SectionPos> stream = SectionPos.cube(SectionPos.of(this.center), 2);
        ServerLevel worldserver = this.level;
        Objects.requireNonNull(this.level);
        stream.filter(worldserver::isVillage).map(SectionPos::center).min(Comparator.comparingDouble(blockposition -> blockposition.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos() {
        BlockPos blockposition = this.findRandomSpawnPos(8);
        return blockposition != null ? Optional.of(blockposition) : Optional.empty();
    }

    private boolean hasMoreWaves() {
        return this.hasBonusWave() ? !this.hasSpawnedBonusWave() : !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders() {
        Iterator<Set<Raider>> iterator = this.groupRaiderMap.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<Raider> set1 = iterator.next();
            for (Raider entityraider : set1) {
                BlockPos blockposition = entityraider.blockPosition();
                if (!entityraider.isRemoved() && entityraider.level().dimension() == this.level.dimension() && this.center.distSqr(blockposition) < 12544.0) {
                    if (entityraider.tickCount <= 600) continue;
                    if (this.level.getEntity(entityraider.getUUID()) == null) {
                        set.add(entityraider);
                    }
                    if (!this.level.isVillage(blockposition) && entityraider.getNoActionTime() > 2400) {
                        entityraider.setTicksOutsideRaid(entityraider.getTicksOutsideRaid() + 1);
                    }
                    if (entityraider.getTicksOutsideRaid() < 30) continue;
                    set.add(entityraider);
                    continue;
                }
                set.add(entityraider);
            }
        }
        for (Raider entityraider1 : set) {
            this.removeFromRaid(entityraider1, true);
            if (!entityraider1.isPatrolLeader()) continue;
            this.removeLeader(entityraider1.getWave());
        }
    }

    private void playSound(BlockPos pos) {
        float f = 13.0f;
        boolean flag = true;
        Collection<ServerPlayer> collection = this.raidEvent.getPlayers();
        long i = this.random.nextLong();
        for (ServerPlayer entityplayer : this.level.players()) {
            Vec3 vec3d = entityplayer.position();
            Vec3 vec3d1 = Vec3.atCenterOf(pos);
            double d0 = Math.sqrt((vec3d1.x - vec3d.x) * (vec3d1.x - vec3d.x) + (vec3d1.z - vec3d.z) * (vec3d1.z - vec3d.z));
            double d1 = vec3d.x + 13.0 / d0 * (vec3d1.x - vec3d.x);
            double d2 = vec3d.z + 13.0 / d0 * (vec3d1.z - vec3d.z);
            if (!(d0 <= 64.0) && !collection.contains(entityplayer)) continue;
            entityplayer.connection.send(new ClientboundSoundPacket(SoundEvents.RAID_HORN, SoundSource.NEUTRAL, d1, entityplayer.getY(), d2, 64.0f, 1.0f, i));
        }
    }

    private void spawnGroup(BlockPos pos) {
        boolean flag = false;
        int i = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance difficultydamagescaler = this.level.getCurrentDifficultyAt(pos);
        boolean flag1 = this.shouldSpawnBonusGroup();
        RaiderType[] araid_wave = RaiderType.VALUES;
        int j = araid_wave.length;
        Raider leader = null;
        ArrayList<Raider> raiders = new ArrayList<Raider>();
        for (int k = 0; k < j; ++k) {
            Raider entityraider;
            RaiderType raid_wave = araid_wave[k];
            int l = this.getDefaultNumSpawns(raid_wave, i, flag1) + this.getPotentialBonusSpawns(raid_wave, this.random, i, difficultydamagescaler, flag1);
            int i1 = 0;
            for (int j1 = 0; j1 < l && (entityraider = raid_wave.entityType.create(this.level, EntitySpawnReason.EVENT)) != null; ++j1) {
                if (!flag && entityraider.canBeLeader()) {
                    entityraider.setPatrolLeader(true);
                    this.setLeader(i, entityraider);
                    flag = true;
                    leader = entityraider;
                }
                this.joinRaid(i, entityraider, pos, false);
                raiders.add(entityraider);
                if (raid_wave.entityType != EntityType.RAVAGER) continue;
                Raider entityraider1 = null;
                if (i == this.getNumGroups(Difficulty.NORMAL)) {
                    entityraider1 = EntityType.PILLAGER.create(this.level, EntitySpawnReason.EVENT);
                } else if (i >= this.getNumGroups(Difficulty.HARD)) {
                    entityraider1 = i1 == 0 ? (Raider)EntityType.EVOKER.create(this.level, EntitySpawnReason.EVENT) : (Raider)EntityType.VINDICATOR.create(this.level, EntitySpawnReason.EVENT);
                }
                ++i1;
                if (entityraider1 == null) continue;
                this.joinRaid(i, entityraider1, pos, false);
                entityraider1.moveTo(pos, 0.0f, 0.0f);
                entityraider1.startRiding(entityraider);
                raiders.add(entityraider);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty();
        CraftEventFactory.callRaidSpawnWaveEvent(this, leader, raiders);
    }

    public void joinRaid(int wave, Raider raider, @Nullable BlockPos pos, boolean existing) {
        boolean flag1 = this.addWaveMob(wave, raider);
        if (flag1) {
            raider.setCurrentRaid(this);
            raider.setWave(wave);
            raider.setCanJoinRaid(true);
            raider.setTicksOutsideRaid(0);
            if (!existing && pos != null) {
                raider.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
                raider.finalizeSpawn(this.level, this.level.getCurrentDifficultyAt(pos), EntitySpawnReason.EVENT, null);
                raider.applyRaidBuffs(this.level, wave, false);
                raider.setOnGround(true);
                this.level.addFreshEntityWithPassengers(raider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(Mth.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float f = 0.0f;
        for (Set<Raider> set : this.groupRaiderMap.values()) {
            for (Raider entityraider : set) {
                f += entityraider.getHealth();
            }
        }
        return f;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(Raider entity, boolean countHealth) {
        boolean flag1;
        Set<Raider> set = this.groupRaiderMap.get(entity.getWave());
        if (set != null && (flag1 = set.remove(entity))) {
            if (countHealth) {
                this.totalHealth -= entity.getHealth();
            }
            entity.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty();
        }
    }

    private void setDirty() {
        this.level.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<BannerPattern> bannerPatternLookup) {
        ItemStack itemstack = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.Builder().addIfRegistered(bannerPatternLookup, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.CYAN).addIfRegistered(bannerPatternLookup, BannerPatterns.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).addIfRegistered(bannerPatternLookup, BannerPatterns.STRIPE_CENTER, DyeColor.GRAY).addIfRegistered(bannerPatternLookup, BannerPatterns.BORDER, DyeColor.LIGHT_GRAY).addIfRegistered(bannerPatternLookup, BannerPatterns.STRIPE_MIDDLE, DyeColor.BLACK).addIfRegistered(bannerPatternLookup, BannerPatterns.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).addIfRegistered(bannerPatternLookup, BannerPatterns.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).addIfRegistered(bannerPatternLookup, BannerPatterns.BORDER, DyeColor.BLACK).build();
        itemstack.set(DataComponents.BANNER_PATTERNS, bannerpatternlayers);
        itemstack.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        itemstack.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        itemstack.set(DataComponents.RARITY, Rarity.UNCOMMON);
        return itemstack;
    }

    @Nullable
    public Raider getLeader(int wave) {
        return this.groupToLeaderMap.get(wave);
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int proximity) {
        int j = this.raidCooldownTicks / 20;
        float f = 0.22f * (float)j - 0.24f;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        float f1 = this.level.random.nextFloat() * ((float)Math.PI * 2);
        for (int k = 0; k < proximity; ++k) {
            int i1;
            float f2 = f1 + (float)Math.PI * (float)k / 8.0f;
            int l = this.center.getX() + Mth.floor(Mth.cos(f2) * 32.0f * f) + this.level.random.nextInt(3) * Mth.floor(f);
            int j1 = this.level.getHeight(Heightmap.Types.WORLD_SURFACE, l, i1 = this.center.getZ() + Mth.floor(Mth.sin(f2) * 32.0f * f) + this.level.random.nextInt(3) * Mth.floor(f));
            if (Mth.abs(j1 - this.center.getY()) > 96) continue;
            blockposition_mutableblockposition.set(l, j1, i1);
            if (this.level.isVillage(blockposition_mutableblockposition) && j > 7) continue;
            boolean flag = true;
            if (!this.level.hasChunksAt(blockposition_mutableblockposition.getX() - 10, blockposition_mutableblockposition.getZ() - 10, blockposition_mutableblockposition.getX() + 10, blockposition_mutableblockposition.getZ() + 10) || !this.level.isPositionEntityTicking(blockposition_mutableblockposition) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(this.level, blockposition_mutableblockposition, EntityType.RAVAGER) && (!this.level.getBlockState((BlockPos)blockposition_mutableblockposition.below()).is(Blocks.SNOW) || !this.level.getBlockState(blockposition_mutableblockposition).isAir())) continue;
            return blockposition_mutableblockposition;
        }
        return null;
    }

    private boolean addWaveMob(int wave, Raider entity) {
        return this.addWaveMob(wave, entity, true);
    }

    public boolean addWaveMob(int wave, Raider entity, boolean countHealth) {
        this.groupRaiderMap.computeIfAbsent(wave, integer -> Sets.newHashSet());
        Set<Raider> set = this.groupRaiderMap.get(wave);
        Raider entityraider1 = null;
        for (Raider entityraider2 : set) {
            if (!entityraider2.getUUID().equals(entity.getUUID())) continue;
            entityraider1 = entityraider2;
            break;
        }
        if (entityraider1 != null) {
            set.remove(entityraider1);
            set.add(entity);
        }
        set.add(entity);
        if (countHealth) {
            this.totalHealth += entity.getHealth();
        }
        this.updateBossbar();
        this.setDirty();
        return true;
    }

    public void setLeader(int wave, Raider entity) {
        this.groupToLeaderMap.put(wave, entity);
        entity.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(entity.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        entity.setDropChance(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int wave) {
        this.groupToLeaderMap.remove(wave);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos center) {
        this.center = center;
    }

    public int getId() {
        return this.id;
    }

    private int getDefaultNumSpawns(RaiderType member, int wave, boolean extra) {
        return extra ? member.spawnsPerWaveBeforeBonus[this.numGroups] : member.spawnsPerWaveBeforeBonus[wave];
    }

    private int getPotentialBonusSpawns(RaiderType member, RandomSource random, int wave, DifficultyInstance localDifficulty, boolean extra) {
        int j;
        Difficulty enumdifficulty = localDifficulty.getDifficulty();
        boolean flag1 = enumdifficulty == Difficulty.EASY;
        boolean flag2 = enumdifficulty == Difficulty.NORMAL;
        switch (member.ordinal()) {
            case 0: 
            case 2: {
                if (flag1) {
                    j = random.nextInt(2);
                    break;
                }
                if (flag2) {
                    j = 1;
                    break;
                }
                j = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag1 || wave <= 2 || wave == 4) {
                    return 0;
                }
                j = 1;
                break;
            }
            case 4: {
                j = !flag1 && extra ? 1 : 0;
            }
        }
        return j > 0 ? random.nextInt(j + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.putInt("Id", this.id);
        nbt.putBoolean("Started", this.started);
        nbt.putBoolean("Active", this.active);
        nbt.putLong("TicksActive", this.ticksActive);
        nbt.putInt("BadOmenLevel", this.raidOmenLevel);
        nbt.putInt("GroupsSpawned", this.groupsSpawned);
        nbt.putInt("PreRaidTicks", this.raidCooldownTicks);
        nbt.putInt("PostRaidTicks", this.postRaidTicks);
        nbt.putFloat("TotalHealth", this.totalHealth);
        nbt.putInt("NumGroups", this.numGroups);
        nbt.putString("Status", this.status.getName());
        nbt.putInt("CX", this.center.getX());
        nbt.putInt("CY", this.center.getY());
        nbt.putInt("CZ", this.center.getZ());
        ListTag nbttaglist = new ListTag();
        for (UUID uuid : this.heroesOfTheVillage) {
            nbttaglist.add(NbtUtils.createUUID(uuid));
        }
        nbt.put("HeroesOfTheVillage", nbttaglist);
        if (!this.persistentDataContainer.isEmpty()) {
            nbt.put(PDC_NBT_KEY, this.persistentDataContainer.toTagCompound());
        }
        return nbt;
    }

    public int getNumGroups(Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float getEnchantOdds() {
        int i = this.getRaidOmenLevel();
        return i == 2 ? 0.1f : (i == 3 ? 0.25f : (i == 4 ? 0.5f : (i == 5 ? 0.75f : 0.0f)));
    }

    public void addHeroOfTheVillage(Entity entity) {
        this.heroesOfTheVillage.add(entity.getUUID());
    }

    public Collection<Raider> getRaiders() {
        return this.groupRaiderMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static enum RaidStatus {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final RaidStatus[] VALUES;

        static RaidStatus getByName(String name) {
            for (RaidStatus raid_status : VALUES) {
                if (!name.equalsIgnoreCase(raid_status.name())) continue;
                return raid_status;
            }
            return ONGOING;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = RaidStatus.values();
        }
    }

    private static enum RaiderType {
        VINDICATOR(EntityType.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final RaiderType[] VALUES;
        final EntityType<? extends Raider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType entitytypes, int[] aint) {
            this.entityType = entitytypes;
            this.spawnsPerWaveBeforeBonus = aint;
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

