/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class NewMinecartBehavior
extends MinecartBehavior {
    public static final int POS_ROT_LERP_TICKS = 3;
    public static final double ON_RAIL_Y_OFFSET = 0.1;
    public static final double OPPOSING_SLOPES_REST_AT_SPEED_THRESHOLD = 0.005;
    @Nullable
    private StepPartialTicks cacheIndexAlpha;
    private int cachedLerpDelay;
    private float cachedPartialTick;
    private int lerpDelay = 0;
    public final List<MinecartStep> lerpSteps = new LinkedList<MinecartStep>();
    public final List<MinecartStep> currentLerpSteps = new LinkedList<MinecartStep>();
    public double currentLerpStepsTotalWeight = 0.0;
    public MinecartStep oldLerp = MinecartStep.ZERO;

    public NewMinecartBehavior(AbstractMinecart minecart) {
        super(minecart);
    }

    @Override
    public void tick() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            if (this.minecart.isFirstTick()) {
                this.minecart.setOnRails(BaseRailBlock.isRail(iblockdata));
                this.adjustToRails(blockposition, iblockdata, true);
            }
            this.minecart.applyGravity();
            this.minecart.moveAlongTrack(worldserver);
        } else {
            this.lerpClientPositionAndRotation();
            boolean flag = BaseRailBlock.isRail(this.level().getBlockState(this.minecart.getCurrentBlockPosOrRailBelow()));
            this.minecart.setOnRails(flag);
        }
    }

    private void lerpClientPositionAndRotation() {
        if (--this.lerpDelay <= 0) {
            this.setOldLerpValues();
            this.currentLerpSteps.clear();
            if (!this.lerpSteps.isEmpty()) {
                this.currentLerpSteps.addAll(this.lerpSteps);
                this.lerpSteps.clear();
                this.currentLerpStepsTotalWeight = 0.0;
                for (MinecartStep newminecartbehavior_a : this.currentLerpSteps) {
                    this.currentLerpStepsTotalWeight += (double)newminecartbehavior_a.weight;
                }
                int n = this.lerpDelay = this.currentLerpStepsTotalWeight == 0.0 ? 0 : 3;
            }
        }
        if (this.cartHasPosRotLerp()) {
            this.setPos(this.getCartLerpPosition(1.0f));
            this.setDeltaMovement(this.getCartLerpMovements(1.0f));
            this.setXRot(this.getCartLerpXRot(1.0f));
            this.setYRot(this.getCartLerpYRot(1.0f));
        }
    }

    public void setOldLerpValues() {
        this.oldLerp = new MinecartStep(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), 0.0f);
    }

    public boolean cartHasPosRotLerp() {
        return !this.currentLerpSteps.isEmpty();
    }

    public float getCartLerpXRot(float tickDelta) {
        StepPartialTicks newminecartbehavior_b = this.getCurrentLerpStep(tickDelta);
        return Mth.rotLerp(newminecartbehavior_b.partialTicksInStep, newminecartbehavior_b.previousStep.xRot, newminecartbehavior_b.currentStep.xRot);
    }

    public float getCartLerpYRot(float tickDelta) {
        StepPartialTicks newminecartbehavior_b = this.getCurrentLerpStep(tickDelta);
        return Mth.rotLerp(newminecartbehavior_b.partialTicksInStep, newminecartbehavior_b.previousStep.yRot, newminecartbehavior_b.currentStep.yRot);
    }

    public Vec3 getCartLerpPosition(float tickDelta) {
        StepPartialTicks newminecartbehavior_b = this.getCurrentLerpStep(tickDelta);
        return Mth.lerp((double)newminecartbehavior_b.partialTicksInStep, newminecartbehavior_b.previousStep.position, newminecartbehavior_b.currentStep.position);
    }

    public Vec3 getCartLerpMovements(float tickDelta) {
        StepPartialTicks newminecartbehavior_b = this.getCurrentLerpStep(tickDelta);
        return Mth.lerp((double)newminecartbehavior_b.partialTicksInStep, newminecartbehavior_b.previousStep.movement, newminecartbehavior_b.currentStep.movement);
    }

    private StepPartialTicks getCurrentLerpStep(float tickDelta) {
        int i;
        if (tickDelta == this.cachedPartialTick && this.lerpDelay == this.cachedLerpDelay && this.cacheIndexAlpha != null) {
            return this.cacheIndexAlpha;
        }
        float f1 = ((float)(3 - this.lerpDelay) + tickDelta) / 3.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        boolean flag = false;
        for (i = 0; i < this.currentLerpSteps.size(); ++i) {
            float f4 = this.currentLerpSteps.get((int)i).weight;
            if (!(f4 > 0.0f) || !((double)(f2 += f4) >= this.currentLerpStepsTotalWeight * (double)f1)) continue;
            float f5 = f2 - f4;
            f3 = (float)(((double)f1 * this.currentLerpStepsTotalWeight - (double)f5) / (double)f4);
            flag = true;
            break;
        }
        if (!flag) {
            i = this.currentLerpSteps.size() - 1;
        }
        MinecartStep newminecartbehavior_a = this.currentLerpSteps.get(i);
        MinecartStep newminecartbehavior_a1 = i > 0 ? this.currentLerpSteps.get(i - 1) : this.oldLerp;
        this.cacheIndexAlpha = new StepPartialTicks(f3, newminecartbehavior_a, newminecartbehavior_a1);
        this.cachedLerpDelay = this.lerpDelay;
        this.cachedPartialTick = tickDelta;
        return this.cacheIndexAlpha;
    }

    public void adjustToRails(BlockPos pos, BlockState blockState, boolean ignoreWeight) {
        if (BaseRailBlock.isRail(blockState)) {
            boolean flag4;
            Vec3 vec3d7;
            Vec3 vec3d6;
            boolean flag1;
            RailShape blockpropertytrackposition = blockState.getValue(((BaseRailBlock)blockState.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
            Vec3 vec3d = new Vec3((Vec3i)pair.getFirst()).scale(0.5);
            Vec3 vec3d1 = new Vec3((Vec3i)pair.getSecond()).scale(0.5);
            Vec3 vec3d2 = vec3d.horizontal();
            Vec3 vec3d3 = vec3d1.horizontal();
            if (this.getDeltaMovement().length() > (double)1.0E-5f && this.getDeltaMovement().dot(vec3d2) < this.getDeltaMovement().dot(vec3d3) || this.isDecending(vec3d3, blockpropertytrackposition)) {
                Vec3 vec3d4 = vec3d2;
                vec3d2 = vec3d3;
                vec3d3 = vec3d4;
            }
            float f = 180.0f - (float)(Math.atan2(vec3d2.z, vec3d2.x) * 180.0 / Math.PI);
            f += this.minecart.isFlipped() ? 180.0f : 0.0f;
            Vec3 vec3d5 = this.position();
            boolean bl = flag1 = vec3d.x() != vec3d1.x() && vec3d.z() != vec3d1.z();
            if (flag1) {
                vec3d6 = vec3d1.subtract(vec3d);
                Vec3 vec3d8 = vec3d5.subtract(pos.getBottomCenter()).subtract(vec3d);
                Vec3 vec3d9 = vec3d6.scale(vec3d6.dot(vec3d8) / vec3d6.dot(vec3d6));
                vec3d7 = pos.getBottomCenter().add(vec3d).add(vec3d9);
                f = 180.0f - (float)(Math.atan2(vec3d9.z, vec3d9.x) * 180.0 / Math.PI);
                f += this.minecart.isFlipped() ? 180.0f : 0.0f;
            } else {
                boolean flag2 = vec3d.subtract((Vec3)vec3d1).x != 0.0;
                boolean flag3 = vec3d.subtract((Vec3)vec3d1).z != 0.0;
                vec3d7 = new Vec3(flag3 ? pos.getCenter().x : vec3d5.x, pos.getY(), flag2 ? pos.getCenter().z : vec3d5.z);
            }
            vec3d6 = vec3d7.subtract(vec3d5);
            this.setPos(vec3d5.add(vec3d6));
            float f1 = 0.0f;
            boolean bl2 = flag4 = vec3d.y() != vec3d1.y();
            if (flag4) {
                Vec3 vec3d10 = pos.getBottomCenter().add(vec3d3);
                double d0 = vec3d10.distanceTo(this.position());
                this.setPos(this.position().add(0.0, d0 + 0.1, 0.0));
                f1 = this.minecart.isFlipped() ? 45.0f : -45.0f;
            } else {
                this.setPos(this.position().add(0.0, 0.1, 0.0));
            }
            this.setRotation(f, f1);
            double d1 = vec3d5.distanceTo(this.position());
            if (d1 > 0.0) {
                this.lerpSteps.add(new MinecartStep(this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), ignoreWeight ? 0.0f : (float)d1));
            }
        }
    }

    private void setRotation(float yaw, float pitch) {
        double d0 = Math.abs(yaw - this.getYRot());
        if (d0 >= 175.0 && d0 <= 185.0) {
            this.minecart.setFlipped(!this.minecart.isFlipped());
            yaw -= 180.0f;
            pitch *= -1.0f;
        }
        pitch = Math.clamp(pitch, -45.0f, 45.0f);
        this.setXRot(pitch % 360.0f);
        this.setYRot(yaw % 360.0f);
    }

    @Override
    public void moveAlongTrack(ServerLevel world) {
        TrackIteration newminecartbehavior_c = new TrackIteration();
        while (newminecartbehavior_c.shouldIterate() && this.minecart.isAlive()) {
            Vec3 vec3d1;
            Vec3 vec3d = this.getDeltaMovement();
            BlockPos blockposition = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            boolean flag = BaseRailBlock.isRail(iblockdata);
            if (this.minecart.isOnRails() != flag) {
                this.minecart.setOnRails(flag);
                this.adjustToRails(blockposition, iblockdata, false);
            }
            if (flag) {
                this.minecart.resetFallDistance();
                this.minecart.setOldPosAndRot();
                if (iblockdata.is(Blocks.ACTIVATOR_RAIL)) {
                    this.minecart.activateMinecart(blockposition.getX(), blockposition.getY(), blockposition.getZ(), iblockdata.getValue(PoweredRailBlock.POWERED));
                }
                RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
                vec3d1 = this.calculateTrackSpeed(world, vec3d.horizontal(), newminecartbehavior_c, blockposition, iblockdata, blockpropertytrackposition);
                newminecartbehavior_c.movementLeft = newminecartbehavior_c.firstIteration ? vec3d1.horizontalDistance() : (newminecartbehavior_c.movementLeft += vec3d1.horizontalDistance() - vec3d.horizontalDistance());
                this.setDeltaMovement(vec3d1);
                newminecartbehavior_c.movementLeft = this.minecart.makeStepAlongTrack(blockposition, blockpropertytrackposition, newminecartbehavior_c.movementLeft);
            } else {
                this.minecart.comeOffTrack(world);
                newminecartbehavior_c.movementLeft = 0.0;
            }
            Vec3 vec3d2 = this.position();
            vec3d1 = vec3d2.subtract(this.minecart.oldPosition());
            double d0 = vec3d1.length();
            if (d0 > (double)1.0E-5f) {
                if (vec3d1.horizontalDistanceSqr() > (double)1.0E-5f) {
                    float f = 180.0f - (float)(Math.atan2(vec3d1.z, vec3d1.x) * 180.0 / Math.PI);
                    float f1 = this.minecart.onGround() && !this.minecart.isOnRails() ? 0.0f : 90.0f - (float)(Math.atan2(vec3d1.horizontalDistance(), vec3d1.y) * 180.0 / Math.PI);
                    this.setRotation(f += this.minecart.isFlipped() ? 180.0f : 0.0f, f1 *= this.minecart.isFlipped() ? -1.0f : 1.0f);
                } else if (!this.minecart.isOnRails()) {
                    this.setXRot(this.minecart.onGround() ? 0.0f : Mth.rotLerp(0.2f, this.getXRot(), 0.0f));
                }
                this.lerpSteps.add(new MinecartStep(vec3d2, this.getDeltaMovement(), this.getYRot(), this.getXRot(), (float)Math.min(d0, this.getMaxSpeed(world))));
            } else if (vec3d.horizontalDistanceSqr() > 0.0) {
                this.lerpSteps.add(new MinecartStep(vec3d2, this.getDeltaMovement(), this.getYRot(), this.getXRot(), 1.0f));
            }
            if (d0 > (double)1.0E-5f || newminecartbehavior_c.firstIteration) {
                this.minecart.applyEffectsFromBlocks();
                this.minecart.applyEffectsFromBlocks();
            }
            newminecartbehavior_c.firstIteration = false;
        }
    }

    private Vec3 calculateTrackSpeed(ServerLevel world, Vec3 horizontalVelocity, TrackIteration iteration, BlockPos pos, BlockState railState, RailShape railShape) {
        Vec3 vec3d2;
        Vec3 vec3d1 = horizontalVelocity;
        if (!iteration.hasGainedSlopeSpeed && (vec3d2 = this.calculateSlopeSpeed(horizontalVelocity, railShape)).horizontalDistanceSqr() != horizontalVelocity.horizontalDistanceSqr()) {
            iteration.hasGainedSlopeSpeed = true;
            vec3d1 = vec3d2;
        }
        if (iteration.firstIteration && (vec3d2 = this.calculatePlayerInputSpeed(vec3d1)).horizontalDistanceSqr() != vec3d1.horizontalDistanceSqr()) {
            iteration.hasHalted = true;
            vec3d1 = vec3d2;
        }
        if (!iteration.hasHalted && (vec3d2 = this.calculateHaltTrackSpeed(vec3d1, railState)).horizontalDistanceSqr() != vec3d1.horizontalDistanceSqr()) {
            iteration.hasHalted = true;
            vec3d1 = vec3d2;
        }
        if (iteration.firstIteration && (vec3d1 = this.minecart.applyNaturalSlowdown(vec3d1)).lengthSqr() > 0.0) {
            double d0 = Math.min(vec3d1.length(), this.minecart.getMaxSpeed(world));
            vec3d1 = vec3d1.normalize().scale(d0);
        }
        if (!iteration.hasBoosted && (vec3d2 = this.calculateBoostTrackSpeed(vec3d1, pos, railState)).horizontalDistanceSqr() != vec3d1.horizontalDistanceSqr()) {
            iteration.hasBoosted = true;
            vec3d1 = vec3d2;
        }
        return vec3d1;
    }

    private Vec3 calculateSlopeSpeed(Vec3 horizontalVelocity, RailShape railShape) {
        double d0 = Math.max(0.0078125, horizontalVelocity.horizontalDistance() * 0.02);
        if (this.minecart.isInWater()) {
            d0 *= 0.2;
        }
        return switch (railShape) {
            case RailShape.ASCENDING_EAST -> horizontalVelocity.add(-d0, 0.0, 0.0);
            case RailShape.ASCENDING_WEST -> horizontalVelocity.add(d0, 0.0, 0.0);
            case RailShape.ASCENDING_NORTH -> horizontalVelocity.add(0.0, 0.0, d0);
            case RailShape.ASCENDING_SOUTH -> horizontalVelocity.add(0.0, 0.0, -d0);
            default -> horizontalVelocity;
        };
    }

    private Vec3 calculatePlayerInputSpeed(Vec3 horizontalVelocity) {
        Entity entity = this.minecart.getFirstPassenger();
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            Vec3 vec3d1 = entityplayer.getLastClientMoveIntent();
            if (vec3d1.lengthSqr() > 0.0) {
                Vec3 vec3d2 = vec3d1.normalize();
                double d0 = horizontalVelocity.horizontalDistanceSqr();
                if (vec3d2.lengthSqr() > 0.0 && d0 < 0.01) {
                    return horizontalVelocity.add(new Vec3(vec3d2.x, 0.0, vec3d2.z).normalize().scale(0.001));
                }
            }
            return horizontalVelocity;
        }
        return horizontalVelocity;
    }

    private Vec3 calculateHaltTrackSpeed(Vec3 velocity, BlockState railState) {
        return railState.is(Blocks.POWERED_RAIL) && !railState.getValue(PoweredRailBlock.POWERED).booleanValue() ? (velocity.length() < 0.03 ? Vec3.ZERO : velocity.scale(0.5)) : velocity;
    }

    private Vec3 calculateBoostTrackSpeed(Vec3 velocity, BlockPos railPos, BlockState railState) {
        if (railState.is(Blocks.POWERED_RAIL) && railState.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            if (velocity.length() > 0.01) {
                return velocity.normalize().scale(velocity.length() + 0.06);
            }
            Vec3 vec3d1 = this.minecart.getRedstoneDirection(railPos);
            return vec3d1.lengthSqr() <= 0.0 ? velocity : vec3d1.scale(velocity.length() + 0.2);
        }
        return velocity;
    }

    @Override
    public double stepAlongTrack(BlockPos blockPos, RailShape railShape, double remainingMovement) {
        if (remainingMovement < (double)1.0E-5f) {
            return 0.0;
        }
        Vec3 vec3d = this.position();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(railShape);
        Vec3i baseblockposition = (Vec3i)pair.getFirst();
        Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
        Vec3 vec3d1 = this.getDeltaMovement().horizontal();
        if (vec3d1.length() < (double)1.0E-5f) {
            this.setDeltaMovement(Vec3.ZERO);
            return 0.0;
        }
        boolean flag = baseblockposition.getY() != baseblockposition1.getY();
        Vec3 vec3d2 = new Vec3(baseblockposition1).scale(0.5).horizontal();
        Vec3 vec3d3 = new Vec3(baseblockposition).scale(0.5).horizontal();
        if (vec3d1.dot(vec3d3) < vec3d1.dot(vec3d2)) {
            vec3d3 = vec3d2;
        }
        Vec3 vec3d4 = blockPos.getBottomCenter().add(vec3d3).add(0.0, 0.1, 0.0).add(vec3d3.normalize().scale(1.0E-5f));
        if (flag && !this.isDecending(vec3d1, railShape)) {
            vec3d4 = vec3d4.add(0.0, 1.0, 0.0);
        }
        Vec3 vec3d5 = vec3d4.subtract(this.position()).normalize();
        vec3d1 = vec3d5.scale(vec3d1.length() / vec3d5.horizontalDistance());
        Vec3 vec3d6 = vec3d.add(vec3d1.normalize().scale(remainingMovement * (double)(flag ? Mth.SQRT_OF_TWO : 1.0f)));
        if (vec3d.distanceToSqr(vec3d4) <= vec3d.distanceToSqr(vec3d6)) {
            remainingMovement = vec3d4.subtract(vec3d6).horizontalDistance();
            vec3d6 = vec3d4;
        } else {
            remainingMovement = 0.0;
        }
        this.minecart.move(MoverType.SELF, vec3d6.subtract(vec3d));
        BlockState iblockdata = this.level().getBlockState(BlockPos.containing(vec3d6));
        if (flag) {
            RailShape blockpropertytrackposition1;
            if (BaseRailBlock.isRail(iblockdata) && this.restAtVShape(railShape, blockpropertytrackposition1 = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty()))) {
                return 0.0;
            }
            double d1 = vec3d4.horizontal().distanceTo(this.position().horizontal());
            double d2 = vec3d4.y + (this.isDecending(vec3d1, railShape) ? d1 : -d1);
            if (this.position().y < d2) {
                this.setPos(this.position().x, d2, this.position().z);
            }
        }
        if (this.position().distanceTo(vec3d) < (double)1.0E-5f && vec3d6.distanceTo(vec3d) > (double)1.0E-5f) {
            this.setDeltaMovement(Vec3.ZERO);
            return 0.0;
        }
        this.setDeltaMovement(vec3d1);
        return remainingMovement;
    }

    private boolean restAtVShape(RailShape currentRailShape, RailShape newRailShape) {
        if (this.getDeltaMovement().lengthSqr() < 0.005 && newRailShape.isSlope() && this.isDecending(this.getDeltaMovement(), currentRailShape) && !this.isDecending(this.getDeltaMovement(), newRailShape)) {
            this.setDeltaMovement(Vec3.ZERO);
            return true;
        }
        return false;
    }

    @Override
    public double getMaxSpeed(ServerLevel world) {
        Double maxSpeed = this.minecart.maxSpeed;
        if (maxSpeed != null) {
            return this.minecart.isInWater() ? maxSpeed / 2.0 : maxSpeed;
        }
        return (double)world.getGameRules().getInt(GameRules.RULE_MINECART_MAX_SPEED) * (this.minecart.isInWater() ? 0.5 : 1.0) / 20.0;
    }

    private boolean isDecending(Vec3 velocity, RailShape railShape) {
        return switch (railShape) {
            case RailShape.ASCENDING_EAST -> velocity.x < 0.0;
            case RailShape.ASCENDING_WEST -> velocity.x > 0.0;
            case RailShape.ASCENDING_NORTH -> velocity.z > 0.0;
            case RailShape.ASCENDING_SOUTH -> velocity.z < 0.0;
            default -> false;
        };
    }

    @Override
    public double getSlowdownFactor() {
        if (this.minecart.frictionState == TriState.FALSE) {
            return 1.0;
        }
        return this.minecart.isVehicle() || !this.minecart.slowWhenEmpty ? 0.997 : 0.975;
    }

    @Override
    public boolean pushAndPickupEntities() {
        boolean flag = this.pickupEntities(this.minecart.getBoundingBox().inflate(0.2, 0.0, 0.2));
        if (!this.minecart.horizontalCollision && !this.minecart.verticalCollision) {
            return false;
        }
        boolean flag1 = this.pushEntities(this.minecart.getBoundingBox().inflate(1.0E-7));
        return flag && !flag1;
    }

    public boolean pickupEntities(AABB box) {
        List<Entity> list;
        if (this.minecart.isRideable() && !this.minecart.isVehicle() && !(list = this.level().getEntities(this.minecart, box, EntitySelector.pushableBy(this.minecart))).isEmpty()) {
            for (Entity entity : list) {
                boolean flag;
                if (entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || this.minecart.isVehicle() || entity.isPassenger()) continue;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled() || !(flag = entity.startRiding(this.minecart))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean pushEntities(AABB box) {
        boolean flag;
        block4: {
            block3: {
                flag = false;
                if (!this.minecart.isRideable()) break block3;
                List<Entity> list = this.level().getEntities(this.minecart, box, EntitySelector.pushableBy(this.minecart));
                if (list.isEmpty()) break block4;
                for (Entity entity : list) {
                    if (!(entity instanceof Player) && !(entity instanceof IronGolem) && !(entity instanceof AbstractMinecart) && !this.minecart.isVehicle() && !entity.isPassenger()) continue;
                    if (!this.minecart.isPassengerOfSameVehicle(entity)) {
                        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                        this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                        if (collisionEvent.isCancelled()) continue;
                    }
                    entity.push(this.minecart);
                    flag = true;
                }
                break block4;
            }
            for (Entity entity1 : this.level().getEntities(this.minecart, box)) {
                if (this.minecart.hasPassenger(entity1) || !entity1.isPushable() || !(entity1 instanceof AbstractMinecart)) continue;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) continue;
                entity1.push(this.minecart);
                flag = true;
            }
        }
        return flag;
    }

    public record MinecartStep(Vec3 position, Vec3 movement, float yRot, float xRot, float weight) {
        public static final StreamCodec<ByteBuf, MinecartStep> STREAM_CODEC = StreamCodec.composite(Vec3.STREAM_CODEC, MinecartStep::position, Vec3.STREAM_CODEC, MinecartStep::movement, ByteBufCodecs.ROTATION_BYTE, MinecartStep::yRot, ByteBufCodecs.ROTATION_BYTE, MinecartStep::xRot, ByteBufCodecs.FLOAT, MinecartStep::weight, MinecartStep::new);
        public static MinecartStep ZERO = new MinecartStep(Vec3.ZERO, Vec3.ZERO, 0.0f, 0.0f, 0.0f);
    }

    private record StepPartialTicks(float partialTicksInStep, MinecartStep currentStep, MinecartStep previousStep) {
    }

    private static class TrackIteration {
        double movementLeft = 0.0;
        boolean firstIteration = true;
        boolean hasGainedSlopeSpeed = false;
        boolean hasHalted = false;
        boolean hasBoosted = false;

        TrackIteration() {
        }

        public boolean shouldIterate() {
            return this.firstIteration || this.movementLeft > (double)1.0E-5f;
        }
    }
}

