/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class AbstractCraftingMenu
extends RecipeBookMenu {
    private final int width;
    private final int height;
    public final TransientCraftingContainer craftSlots;
    public final ResultContainer resultSlots = new ResultContainer();

    public AbstractCraftingMenu(MenuType<?> containers, int i, int j, int k, Inventory playerInventory) {
        super(containers, i);
        this.width = j;
        this.height = k;
        this.craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, j, k, playerInventory.player);
        this.craftSlots.resultInventory = this.resultSlots;
    }

    protected Slot addResultSlot(Player player, int x, int y) {
        return this.addSlot(new ResultSlot(player, this.craftSlots, this.resultSlots, 0, x, y));
    }

    protected void addCraftingGridSlots(int x, int y) {
        for (int k = 0; k < this.width; ++k) {
            for (int l = 0; l < this.height; ++l) {
                this.addSlot(new Slot(this.craftSlots, l + k * this.width, x + l * 18, y + k * 18));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean craftAll, boolean creative, RecipeHolder<?> recipe, ServerLevel world, Inventory inventory) {
        RecipeBookMenu.PostPlaceAction containerrecipebook_a;
        RecipeHolder<CraftingRecipe> recipeholder1 = recipe;
        this.beginPlacingRecipe();
        try {
            List<Slot> list = this.getInputGridSlots();
            containerrecipebook_a = ServerPlaceRecipe.placeRecipe(new ServerPlaceRecipe.CraftingMenuAccess<CraftingRecipe>(){

                @Override
                public void fillCraftSlotsStackedContents(StackedItemContents finder) {
                    AbstractCraftingMenu.this.fillCraftSlotsStackedContents(finder);
                }

                @Override
                public void clearCraftingContent() {
                    AbstractCraftingMenu.this.resultSlots.clearContent();
                    AbstractCraftingMenu.this.craftSlots.clearContent();
                }

                @Override
                public boolean recipeMatches(RecipeHolder<CraftingRecipe> entry) {
                    return entry.value().matches(AbstractCraftingMenu.this.craftSlots.asCraftInput(), AbstractCraftingMenu.this.owner().level());
                }
            }, this.width, this.height, list, list, inventory, recipeholder1, craftAll, creative);
        }
        finally {
            this.finishPlacingRecipe(world, recipeholder1);
        }
        return containerrecipebook_a;
    }

    protected void beginPlacingRecipe() {
    }

    protected void finishPlacingRecipe(ServerLevel world, RecipeHolder<CraftingRecipe> recipe) {
    }

    public abstract Slot getResultSlot();

    public abstract List<Slot> getInputGridSlots();

    public int getGridWidth() {
        return this.width;
    }

    public int getGridHeight() {
        return this.height;
    }

    protected abstract Player owner();

    @Override
    public void fillCraftSlotsStackedContents(StackedItemContents finder) {
        this.craftSlots.fillStackedContents(finder);
    }
}

