/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.inventory.CraftInventoryView;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.block.BlockExpEvent;

public class GrindstoneMenu
extends AbstractContainerMenu {
    private CraftInventoryView bukkitEntity = null;
    private org.bukkit.entity.Player player;
    public static final int MAX_NAME_LENGTH = 35;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Container resultSlots;
    final Container repairSlots;
    private final ContainerLevelAccess access;

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryGrindstone inventory = new CraftInventoryGrindstone(this.repairSlots, this.resultSlots);
        this.bukkitEntity = new CraftInventoryView<GrindstoneMenu, CraftInventoryGrindstone>((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public GrindstoneMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public GrindstoneMenu(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(MenuType.GRINDSTONE, syncId);
        this.resultSlots = new ResultContainer(this.createBlockHolder(context));
        this.repairSlots = new SimpleContainer(this.createBlockHolder(context), 2){

            @Override
            public void setChanged() {
                super.setChanged();
                GrindstoneMenu.this.slotsChanged(this);
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.access = context;
        this.addSlot(new Slot(this, this.repairSlots, 0, 49, 19){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(stack);
            }
        });
        this.addSlot(new Slot(this, this.repairSlots, 1, 49, 40){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.isDamageableItem() || EnchantmentHelper.hasAnyEnchantments(stack);
            }
        });
        this.addSlot(new Slot(this.resultSlots, 2, 129, 34){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            @Override
            public void onTake(Player player, ItemStack stack) {
                context.execute((world, blockposition) -> {
                    if (world instanceof ServerLevel) {
                        BlockExpEvent event = new BlockExpEvent((Block)CraftBlock.at(world, blockposition), this.getExperienceAmount((Level)world));
                        event.callEvent();
                        ExperienceOrb.award((ServerLevel)world, Vec3.atCenterOf(blockposition), event.getExpToDrop(), ExperienceOrb.SpawnReason.GRINDSTONE, player);
                    }
                    world.levelEvent(1042, (BlockPos)blockposition, 0);
                });
                GrindstoneMenu.this.repairSlots.setItem(0, ItemStack.EMPTY);
                GrindstoneMenu.this.repairSlots.setItem(1, ItemStack.EMPTY);
            }

            private int getExperienceAmount(Level world) {
                int j = 0;
                j += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(0));
                if ((j += this.getExperienceFromItem(GrindstoneMenu.this.repairSlots.getItem(1))) > 0) {
                    int k = (int)Math.ceil((double)j / 2.0);
                    return k + world.random.nextInt(k);
                }
                return 0;
            }

            private int getExperienceFromItem(ItemStack stack) {
                int j = 0;
                ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(stack);
                for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    int k = entry.getIntValue();
                    if (holder.is(EnchantmentTags.CURSE)) continue;
                    j += ((Enchantment)holder.value()).getMinCost(k);
                }
                return j;
            }
        });
        this.addStandardInventorySlots(playerInventory, 8, 84);
        this.player = (org.bukkit.entity.Player)playerInventory.player.getBukkitEntity();
    }

    @Override
    public void slotsChanged(Container inventory) {
        super.slotsChanged(inventory);
        if (inventory == this.repairSlots) {
            this.createResult();
            CraftEventFactory.callPrepareResultEvent(this, 2);
        }
    }

    private void createResult() {
        CraftEventFactory.callPrepareGrindstoneEvent(this.getBukkitView(), this.computeResult(this.repairSlots.getItem(0), this.repairSlots.getItem(1)));
        this.sendAllDataToRemote();
        this.broadcastChanges();
    }

    private ItemStack computeResult(ItemStack firstInput, ItemStack secondInput) {
        boolean flag;
        boolean bl = flag = !firstInput.isEmpty() || !secondInput.isEmpty();
        if (!flag) {
            return ItemStack.EMPTY;
        }
        if (firstInput.getCount() <= 1 && secondInput.getCount() <= 1) {
            boolean flag1;
            boolean bl2 = flag1 = !firstInput.isEmpty() && !secondInput.isEmpty();
            if (!flag1) {
                ItemStack itemstack2 = !firstInput.isEmpty() ? firstInput : secondInput;
                return !EnchantmentHelper.hasAnyEnchantments(itemstack2) ? ItemStack.EMPTY : this.removeNonCursesFrom(itemstack2.copy());
            }
            return this.mergeItems(firstInput, secondInput);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack mergeItems(ItemStack firstInput, ItemStack secondInput) {
        ItemStack itemstack2;
        if (!firstInput.is(secondInput.getItem())) {
            return ItemStack.EMPTY;
        }
        int i = Math.max(firstInput.getMaxDamage(), secondInput.getMaxDamage());
        int j = firstInput.getMaxDamage() - firstInput.getDamageValue();
        int k = secondInput.getMaxDamage() - secondInput.getDamageValue();
        int l = j + k + i * 5 / 100;
        int b0 = 1;
        if (!firstInput.isDamageableItem()) {
            if (firstInput.getMaxStackSize() < 2 || !ItemStack.matches(firstInput, secondInput)) {
                return ItemStack.EMPTY;
            }
            b0 = 2;
        }
        if ((itemstack2 = firstInput.copyWithCount(b0)).isDamageableItem()) {
            itemstack2.set(DataComponents.MAX_DAMAGE, i);
            itemstack2.setDamageValue(Math.max(i - l, 0));
        }
        this.mergeEnchantsFrom(itemstack2, secondInput);
        return this.removeNonCursesFrom(itemstack2);
    }

    private void mergeEnchantsFrom(ItemStack target, ItemStack source) {
        EnchantmentHelper.updateEnchantments(target, itemenchantments_a -> {
            ItemEnchantments itemenchantments = EnchantmentHelper.getEnchantmentsForCrafting(source);
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemenchantments.entrySet()) {
                Holder holder = (Holder)entry.getKey();
                if (holder.is(EnchantmentTags.CURSE) && itemenchantments_a.getLevel(holder) != 0) continue;
                itemenchantments_a.upgrade(holder, entry.getIntValue());
            }
        });
    }

    private ItemStack removeNonCursesFrom(ItemStack item) {
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments(item, itemenchantments_a -> itemenchantments_a.removeIf(holder -> !holder.is(EnchantmentTags.CURSE)));
        if (item.is(Items.ENCHANTED_BOOK) && itemenchantments.isEmpty()) {
            item = item.transmuteCopy(Items.BOOK);
        }
        int i = 0;
        for (int j = 0; j < itemenchantments.size(); ++j) {
            i = AnvilMenu.calculateIncreasedRepairCost(i);
        }
        item.set(DataComponents.REPAIR_COST, i);
        return item;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.access.execute((world, blockposition) -> this.clearContainer(player, this.repairSlots));
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return GrindstoneMenu.stillValid(this.access, player, Blocks.GRINDSTONE);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot1 = this.slots.get(slot);
        if (slot1 != null && slot1.hasItem()) {
            ItemStack itemstack1 = slot1.getItem();
            itemstack = itemstack1.copy();
            ItemStack itemstack2 = this.repairSlots.getItem(0);
            ItemStack itemstack3 = this.repairSlots.getItem(1);
            if (slot == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot1.onQuickCraft(itemstack1, itemstack);
            } else if (slot != 0 && slot != 1 ? (!itemstack2.isEmpty() && !itemstack3.isEmpty() ? (slot >= 3 && slot < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : slot >= 30 && slot < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 0, 2, false)) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            } else {
                slot1.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot1.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

