/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.SlotRange;

public class SlotRanges {
    private static final List<SlotRange> SLOTS = Util.make(new ArrayList(), list -> {
        SlotRanges.addSingleSlot(list, "contents", 0);
        SlotRanges.addSlotRange(list, "container.", 0, 54);
        SlotRanges.addSlotRange(list, "hotbar.", 0, 9);
        SlotRanges.addSlotRange(list, "inventory.", 9, 27);
        SlotRanges.addSlotRange(list, "enderchest.", 200, 27);
        SlotRanges.addSlotRange(list, "villager.", 300, 8);
        SlotRanges.addSlotRange(list, "horse.", 500, 15);
        int i = EquipmentSlot.MAINHAND.getIndex(98);
        int j = EquipmentSlot.OFFHAND.getIndex(98);
        SlotRanges.addSingleSlot(list, "weapon", i);
        SlotRanges.addSingleSlot(list, "weapon.mainhand", i);
        SlotRanges.addSingleSlot(list, "weapon.offhand", j);
        SlotRanges.addSlots(list, "weapon.*", i, j);
        int k = EquipmentSlot.HEAD.getIndex(100);
        int l = EquipmentSlot.CHEST.getIndex(100);
        int m = EquipmentSlot.LEGS.getIndex(100);
        int n = EquipmentSlot.FEET.getIndex(100);
        int o = EquipmentSlot.BODY.getIndex(105);
        SlotRanges.addSingleSlot(list, "armor.head", k);
        SlotRanges.addSingleSlot(list, "armor.chest", l);
        SlotRanges.addSingleSlot(list, "armor.legs", m);
        SlotRanges.addSingleSlot(list, "armor.feet", n);
        SlotRanges.addSingleSlot(list, "armor.body", o);
        SlotRanges.addSlots(list, "armor.*", k, l, m, n, o);
        SlotRanges.addSingleSlot(list, "horse.saddle", 400);
        SlotRanges.addSingleSlot(list, "horse.chest", 499);
        SlotRanges.addSingleSlot(list, "player.cursor", 499);
        SlotRanges.addSlotRange(list, "player.crafting.", 500, 4);
    });
    public static final Codec<SlotRange> CODEC = StringRepresentable.fromValues(() -> SLOTS.toArray(new SlotRange[0]));
    private static final Function<String, SlotRange> NAME_LOOKUP = StringRepresentable.createNameLookup((StringRepresentable[])SLOTS.toArray(new SlotRange[0]), name -> name);

    private static SlotRange create(String name, int slotId) {
        return SlotRange.of(name, IntLists.singleton((int)slotId));
    }

    private static SlotRange create(String name, IntList slotIds) {
        return SlotRange.of(name, IntLists.unmodifiable((IntList)slotIds));
    }

    private static SlotRange create(String name, int ... slotIds) {
        return SlotRange.of(name, IntList.of((int[])slotIds));
    }

    private static void addSingleSlot(List<SlotRange> list, String name, int slotId) {
        list.add(SlotRanges.create(name, slotId));
    }

    private static void addSlotRange(List<SlotRange> list, String baseName, int firstSlotId, int slotCount) {
        IntArrayList intList = new IntArrayList(slotCount);
        for (int i = 0; i < slotCount; ++i) {
            int j = firstSlotId + i;
            list.add(SlotRanges.create(baseName + i, j));
            intList.add(j);
        }
        list.add(SlotRanges.create(baseName + "*", (IntList)intList));
    }

    private static void addSlots(List<SlotRange> list, String name, int ... slots) {
        list.add(SlotRanges.create(name, slots));
    }

    @Nullable
    public static SlotRange nameToIds(String name) {
        return NAME_LOOKUP.apply(name);
    }

    public static Stream<String> allNames() {
        return SLOTS.stream().map(StringRepresentable::getSerializedName);
    }

    public static Stream<String> singleSlotNames() {
        return SLOTS.stream().filter(slotRange -> slotRange.size() == 1).map(StringRepresentable::getSerializedName);
    }
}

