/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;

public class AnimalArmorItem
extends Item {
    private final BodyType bodyType;

    public AnimalArmorItem(ArmorMaterial material, BodyType type, Item.Properties settings) {
        super(material.animalProperties(settings, type.allowedEntities));
        this.bodyType = type;
    }

    public AnimalArmorItem(ArmorMaterial material, BodyType type, Holder<SoundEvent> equipSound, boolean damageOnHurt, Item.Properties settings) {
        super(material.animalProperties(settings, equipSound, damageOnHurt, type.allowedEntities));
        this.bodyType = type;
    }

    @Override
    @Override
    public SoundEvent getBreakingSound() {
        return this.bodyType.breakingSound;
    }

    public static enum BodyType {
        EQUESTRIAN(SoundEvents.ITEM_BREAK, EntityType.HORSE),
        CANINE(SoundEvents.WOLF_ARMOR_BREAK, EntityType.WOLF);

        final SoundEvent breakingSound;
        final HolderSet<EntityType<?>> allowedEntities;

        private BodyType(SoundEvent breakSound, EntityType<?> ... allowedEntities) {
            this.breakingSound = breakSound;
            this.allowedEntities = HolderSet.direct(EntityType::builtInRegistryHolder, allowedEntities);
        }
    }
}

