/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class BoatItem
extends Item {
    private final EntityType<? extends AbstractBoat> entityType;

    public BoatItem(EntityType<? extends AbstractBoat> boatEntityType, Item.Properties settings) {
        super(settings);
        this.entityType = boatEntityType;
    }

    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        BlockHitResult movingobjectpositionblock = BoatItem.getPlayerPOVHitResult(world, user, ClipContext.Fluid.ANY);
        if (movingobjectpositionblock.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 vec3d = user.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = world.getEntities(user, user.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), EntitySelector.CAN_BE_PICKED);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = user.getEyePosition();
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!axisalignedbb.contains(vec3d1)) continue;
                return InteractionResult.PASS;
            }
        }
        if (movingobjectpositionblock.getType() == HitResult.Type.BLOCK) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(user, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), itemstack, false, hand, movingobjectpositionblock.getLocation());
            if (event.isCancelled()) {
                return InteractionResult.PASS;
            }
            AbstractBoat abstractboat = this.getBoat(world, movingobjectpositionblock, itemstack, user);
            if (abstractboat == null) {
                return InteractionResult.FAIL;
            }
            abstractboat.setYRot(user.getYRot());
            if (!world.noCollision(abstractboat, abstractboat.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            if (!world.isClientSide) {
                if (CraftEventFactory.callEntityPlaceEvent(world, movingobjectpositionblock.getBlockPos(), movingobjectpositionblock.getDirection(), user, abstractboat, hand).isCancelled()) {
                    return InteractionResult.FAIL;
                }
                if (!world.addFreshEntity(abstractboat)) {
                    return InteractionResult.PASS;
                }
                world.gameEvent((Entity)user, GameEvent.ENTITY_PLACE, movingobjectpositionblock.getLocation());
                itemstack.consume(1, user);
            }
            user.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private AbstractBoat getBoat(Level world, HitResult hitResult, ItemStack stack, Player player) {
        AbstractBoat abstractboat = this.entityType.create(world, EntitySpawnReason.SPAWN_ITEM_USE);
        if (abstractboat != null) {
            Vec3 vec3d = hitResult.getLocation();
            abstractboat.setInitialPos(vec3d.x, vec3d.y, vec3d.z);
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                EntityType.createDefaultStackConfig(worldserver, stack, player).accept(abstractboat);
            }
        }
        return abstractboat;
    }
}

