/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;

    public BrushItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    @Override
    @Override
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BRUSH;
    }

    @Override
    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Override
    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        boolean bl;
        void player2;
        block11: {
            block10: {
                if (remainingUseTicks < 0 || !(user instanceof Player)) {
                    user.releaseUsingItem();
                    return;
                }
                Player player = (Player)user;
                HitResult hitResult = this.calculateHitResult((Player)player2);
                if (!(hitResult instanceof BlockHitResult)) break block10;
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) break block11;
            }
            user.releaseUsingItem();
            return;
        }
        int i = this.getUseDuration(stack, user) - remainingUseTicks + 1;
        boolean bl2 = bl = i % 10 == 5;
        if (bl) {
            SoundEvent soundEvent2;
            Block block;
            HumanoidArm humanoidArm;
            void blockHitResult2;
            BlockPos blockPos = blockHitResult2.getBlockPos();
            BlockState blockState = world.getBlockState(blockPos);
            HumanoidArm humanoidArm2 = humanoidArm = user.getUsedItemHand() == InteractionHand.MAIN_HAND ? player2.getMainArm() : player2.getMainArm().getOpposite();
            if (blockState.shouldSpawnTerrainParticles() && blockState.getRenderShape() != RenderShape.INVISIBLE) {
                this.spawnDustParticles(world, (BlockHitResult)blockHitResult2, blockState, user.getViewVector(0.0f), humanoidArm);
            }
            if ((block = blockState.getBlock()) instanceof BrushableBlock) {
                BrushableBlock brushableBlock = (BrushableBlock)block;
                SoundEvent soundEvent = brushableBlock.getBrushSound();
            } else {
                soundEvent2 = SoundEvents.BRUSH_GENERIC;
            }
            world.playSound((Player)player2, blockPos, soundEvent2, SoundSource.BLOCKS);
            if (world instanceof ServerLevel) {
                BrushableBlockEntity brushableBlockEntity;
                boolean bl22;
                ServerLevel serverLevel = (ServerLevel)world;
                BlockEntity blockEntity = world.getBlockEntity(blockPos);
                if (blockEntity instanceof BrushableBlockEntity && (bl22 = (brushableBlockEntity = (BrushableBlockEntity)blockEntity).brush(world.getGameTime(), serverLevel, (Player)player2, blockHitResult2.getDirection(), stack))) {
                    EquipmentSlot equipmentSlot = stack.equals(player2.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                    stack.hurtAndBreak(1, (LivingEntity)player2, equipmentSlot);
                }
            }
        }
    }

    private HitResult calculateHitResult(Player user) {
        return ProjectileUtil.getHitResultOnViewVector(user, EntitySelector.CAN_BE_PICKED, user.blockInteractionRange());
    }

    private void spawnDustParticles(Level world, BlockHitResult hitResult, BlockState state, Vec3 userRotation, HumanoidArm arm) {
        double d = 3.0;
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = world.getRandom().nextInt(7, 12);
        BlockParticleOption blockParticleOption = new BlockParticleOption(ParticleTypes.BLOCK, state);
        Direction direction = hitResult.getDirection();
        DustParticlesDelta dustParticlesDelta = DustParticlesDelta.fromDirection(userRotation, direction);
        Vec3 vec3 = hitResult.getLocation();
        for (int k = 0; k < j; ++k) {
            world.addParticle(blockParticleOption, vec3.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.y, vec3.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), dustParticlesDelta.xd() * (double)i * 3.0 * world.getRandom().nextDouble(), 0.0, dustParticlesDelta.zd() * (double)i * 3.0 * world.getRandom().nextDouble());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 userRotation, Direction side) {
            double d = 0.0;
            return switch (side) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(userRotation.z(), 0.0, -userRotation.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
            };
        }
    }
}

