/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;

public class EmptyMapItem
extends Item {
    public EmptyMapItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        itemStack.consume(1, user);
        user.awardStat(Stats.ITEM_USED.get(this));
        user.level().playSound(null, user, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, user.getSoundSource(), 1.0f, 1.0f);
        ItemStack itemStack2 = MapItem.create(world, user.getBlockX(), user.getBlockZ(), (byte)0, true, false);
        if (itemStack.isEmpty()) {
            return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack2);
        }
        if (!user.getInventory().add(itemStack2.copy())) {
            user.drop(itemStack2, false);
        }
        return InteractionResult.SUCCESS;
    }
}

