/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;

public class EnderpearlItem
extends Item {
    public EnderpearlItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult use(Level world, net.minecraft.world.entity.player.Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Projectile.Delayed<ThrownEnderpearl> thrownEnderpearl = net.minecraft.world.entity.projectile.Projectile.spawnProjectileFromRotationDelayed(ThrownEnderpearl::new, worldserver, itemstack, user, 0.0f, 1.5f, 1.0f);
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((Player)user.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemstack), (Projectile)thrownEnderpearl.projectile().getBukkitEntity());
            if (event.callEvent() && thrownEnderpearl.attemptSpawn()) {
                if (event.shouldConsume()) {
                    itemstack.consume(1, user);
                } else if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                user.awardStat(Stats.ITEM_USED.get(this));
            } else {
                if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                return InteractionResult.FAIL;
            }
        }
        world.playSound((net.minecraft.world.entity.player.Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        return InteractionResult.SUCCESS;
    }
}

