/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FoodOnAStickItem<T extends Entity>
extends Item {
    private final EntityType<T> canInteractWith;
    private final int consumeItemDamage;

    public FoodOnAStickItem(EntityType<T> target, int damagePerUse, Item.Properties settings) {
        super(settings);
        this.canInteractWith = target;
        this.consumeItemDamage = damagePerUse;
    }

    @Override
    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        Entity entity = user.getControlledVehicle();
        if (user.isPassenger() && entity instanceof ItemSteerable) {
            ItemSteerable itemSteerable = (ItemSteerable)((Object)entity);
            if (entity.getType() == this.canInteractWith && itemSteerable.boost()) {
                EquipmentSlot equipmentSlot = LivingEntity.getSlotForHand(hand);
                ItemStack itemStack2 = itemStack.hurtAndConvertOnBreak(this.consumeItemDamage, Items.FISHING_ROD, user, equipmentSlot);
                return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(itemStack2);
            }
        }
        user.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResult.PASS;
    }
}

