/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class KnowledgeBookItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public KnowledgeBookItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        List list = itemStack.getOrDefault(DataComponents.RECIPES, List.of());
        itemStack.consume(1, user);
        if (list.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!world.isClientSide) {
            RecipeManager recipeManager = world.getServer().getRecipeManager();
            ArrayList list2 = new ArrayList(list.size());
            for (ResourceKey resourceKey : list) {
                Optional<RecipeHolder<?>> optional = recipeManager.byKey(resourceKey);
                if (optional.isPresent()) {
                    list2.add(optional.get());
                    continue;
                }
                LOGGER.error("Invalid recipe: {}", (Object)resourceKey);
                return InteractionResult.FAIL;
            }
            user.awardRecipes(list2);
            user.awardStat(Stats.ITEM_USED.get(this));
        }
        return InteractionResult.SUCCESS;
    }
}

