/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class ShovelItem
extends DiggerItem {
    protected static final Map<Block, BlockState> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public ShovelItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties settings) {
        super(material, BlockTags.MINEABLE_WITH_SHOVEL, attackDamage, attackSpeed, settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = level.getBlockState(blockPos);
        if (context.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        BlockState blockState2 = FLATTENABLES.get(blockState.getBlock());
        BlockState blockState3 = null;
        Runnable afterAction = null;
        if (blockState2 != null && level.getBlockState(blockPos.above()).isAir()) {
            afterAction = () -> level.playSound(player, blockPos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockState3 = blockState2;
        } else if (blockState.getBlock() instanceof CampfireBlock && blockState.getValue(CampfireBlock.LIT).booleanValue()) {
            afterAction = () -> {
                if (!level.isClientSide()) {
                    level.levelEvent(null, 1009, blockPos, 0);
                }
                CampfireBlock.dowse(context.getPlayer(), level, blockPos, blockState);
            };
            blockState3 = (BlockState)blockState.setValue(CampfireBlock.LIT, false);
        }
        if (blockState3 != null) {
            if (!level.isClientSide) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(context.getPlayer(), blockPos, blockState3)) {
                    return InteractionResult.PASS;
                }
                afterAction.run();
                level.setBlock(blockPos, blockState3, 11);
                level.gameEvent(GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of(player, blockState3));
                if (player != null) {
                    context.getItemInHand().hurtAndBreak(1, player, LivingEntity.getSlotForHand(context.getHand()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

