/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;

public class DecoratedPotRecipe
extends CustomRecipe {
    public DecoratedPotRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static ItemStack back(CraftingInput input) {
        return input.getItem(1, 0);
    }

    private static ItemStack left(CraftingInput input) {
        return input.getItem(0, 1);
    }

    private static ItemStack right(CraftingInput input) {
        return input.getItem(2, 1);
    }

    private static ItemStack front(CraftingInput input) {
        return input.getItem(1, 2);
    }

    @Override
    @Override
    public boolean matches(CraftingInput input, Level world) {
        if (input.width() != 3 || input.height() != 3 || input.ingredientCount() != 4) {
            return false;
        }
        return DecoratedPotRecipe.back(input).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.left(input).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.right(input).is(ItemTags.DECORATED_POT_INGREDIENTS) && DecoratedPotRecipe.front(input).is(ItemTags.DECORATED_POT_INGREDIENTS);
    }

    @Override
    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        PotDecorations potDecorations = new PotDecorations(DecoratedPotRecipe.back(input).getItem(), DecoratedPotRecipe.left(input).getItem(), DecoratedPotRecipe.right(input).getItem(), DecoratedPotRecipe.front(input).getItem());
        return DecoratedPotBlockEntity.createDecoratedPotItem(potDecorations);
    }

    @Override
    @Override
    public RecipeSerializer<DecoratedPotRecipe> getSerializer() {
        return RecipeSerializer.DECORATED_POT_RECIPE;
    }
}

