/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(Ingredient::new, recipeitemstack -> recipeitemstack.values);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(holderset -> holderset.size() == 0 ? Optional.empty() : Optional.of(new Ingredient((HolderSet<Item>)holderset)), optional -> optional.map(recipeitemstack -> recipeitemstack.values).orElse(HolderSet.direct(new Holder[0])));
    public static final Codec<HolderSet<Item>> NON_AIR_HOLDER_SET_CODEC = HolderSetCodec.create(Registries.ITEM, Item.CODEC, false);
    public static final Codec<Ingredient> CODEC = ExtraCodecs.nonEmptyHolderSet(NON_AIR_HOLDER_SET_CODEC).xmap(Ingredient::new, recipeitemstack -> recipeitemstack.values);
    private final HolderSet<Item> values;
    @Nullable
    private List<Holder<Item>> items;
    @Nullable
    private List<ItemStack> itemStacks;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static Ingredient ofStacks(List<ItemStack> stacks) {
        Ingredient recipe = Ingredient.of(stacks.stream().map(ItemStack::getItem));
        recipe.itemStacks = stacks;
        return recipe;
    }

    private Ingredient(HolderSet<Item> entries) {
        entries.unwrap().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.AIR.builtInRegistryHolder())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.values = entries;
    }

    public static boolean testOptionalIngredient(Optional<Ingredient> ingredient, ItemStack stack) {
        Optional<Boolean> optional1 = ingredient.map(recipeitemstack -> recipeitemstack.test(stack));
        Objects.requireNonNull(stack);
        return (Boolean)optional1.orElseGet(stack::isEmpty);
    }

    public List<Holder<Item>> items() {
        if (this.items == null) {
            this.items = ImmutableList.copyOf(this.values);
        }
        return this.items;
    }

    @Override
    public boolean test(ItemStack itemstack) {
        if (this.isExact()) {
            for (ItemStack itemstack1 : this.itemStacks()) {
                if (itemstack1.getItem() != itemstack.getItem() || !ItemStack.isSameItemSameComponents(itemstack, itemstack1)) continue;
                return true;
            }
            return false;
        }
        List<Holder<Item>> list = this.items();
        for (int i = 0; i < list.size(); ++i) {
            if (!itemstack.is(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Ingredient) {
            Ingredient recipeitemstack = (Ingredient)object;
            return Objects.equals(this.values, recipeitemstack.values) && Objects.equals(this.itemStacks, recipeitemstack.itemStacks);
        }
        return false;
    }

    public static Ingredient of(ItemLike item) {
        return new Ingredient(HolderSet.direct(item.asItem().builtInRegistryHolder()));
    }

    public static Ingredient of(ItemLike ... items) {
        return Ingredient.of(Arrays.stream(items));
    }

    public static Ingredient of(Stream<? extends ItemLike> stacks) {
        return new Ingredient(HolderSet.direct(stacks.map(imaterial -> imaterial.asItem().builtInRegistryHolder()).toList()));
    }

    public static Ingredient of(HolderSet<Item> tag) {
        return new Ingredient(tag);
    }

    public SlotDisplay display() {
        if (this.isExact()) {
            return new SlotDisplay.Composite(this.itemStacks().stream().map(SlotDisplay.ItemStackSlotDisplay::new).toList());
        }
        return (SlotDisplay)((Object)this.values.unwrap().map(SlotDisplay.TagSlotDisplay::new, list -> new SlotDisplay.Composite(list.stream().map(Ingredient::displayForSingleItem).toList())));
    }

    public static SlotDisplay optionalIngredientToDisplay(Optional<Ingredient> ingredient) {
        return ingredient.map(Ingredient::display).orElse(SlotDisplay.Empty.INSTANCE);
    }

    private static SlotDisplay displayForSingleItem(Holder<Item> displayedItem) {
        SlotDisplay.ItemSlotDisplay slotdisplay_d = new SlotDisplay.ItemSlotDisplay(displayedItem);
        ItemStack itemstack = displayedItem.value().getCraftingRemainder();
        if (!itemstack.isEmpty()) {
            SlotDisplay.ItemStackSlotDisplay slotdisplay_f = new SlotDisplay.ItemStackSlotDisplay(itemstack);
            return new SlotDisplay.WithRemainder(slotdisplay_d, slotdisplay_f);
        }
        return slotdisplay_d;
    }
}

