/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.crafting.Ingredient;

public class PlacementInfo {
    public static final PlacementInfo NOT_PLACEABLE = new PlacementInfo(List.of(), List.of(), List.of());
    private final List<Ingredient> ingredients;
    private final List<StackedContents.IngredientInfo<ItemOrExact>> unpackedIngredients;
    private final List<Optional<SlotInfo>> slotInfo;

    private PlacementInfo(List<Ingredient> ingredients, List<StackedContents.IngredientInfo<ItemOrExact>> rawIngredients, List<Optional<SlotInfo>> placementSlots) {
        this.ingredients = ingredients;
        this.unpackedIngredients = rawIngredients;
        this.slotInfo = placementSlots;
    }

    public static StackedContents.IngredientInfo<ItemOrExact> ingredientToContents(Ingredient ingredient) {
        return StackedItemContents.convertIngredientContents(ingredient.isExact() ? ingredient.itemStacks().stream().map(ItemOrExact.Exact::new) : ingredient.items().stream().map(ItemOrExact.Item::new), ingredient.isExact());
    }

    public static PlacementInfo create(Ingredient ingredient) {
        if (ingredient.items().isEmpty()) {
            return NOT_PLACEABLE;
        }
        StackedContents.IngredientInfo<ItemOrExact> ingredientInfo = PlacementInfo.ingredientToContents(ingredient);
        SlotInfo slotInfo = new SlotInfo(0);
        return new PlacementInfo(List.of(ingredient), List.of(ingredientInfo), List.of(Optional.of(slotInfo)));
    }

    public static PlacementInfo createFromOptionals(List<Optional<Ingredient>> ingredients) {
        int i = ingredients.size();
        ArrayList<Ingredient> list = new ArrayList<Ingredient>(i);
        ArrayList<StackedContents.IngredientInfo<ItemOrExact>> list2 = new ArrayList<StackedContents.IngredientInfo<ItemOrExact>>(i);
        ArrayList<Optional<SlotInfo>> list3 = new ArrayList<Optional<SlotInfo>>(i);
        int j = 0;
        for (Optional<Ingredient> optional : ingredients) {
            if (optional.isPresent()) {
                Ingredient ingredient = optional.get();
                if (ingredient.items().isEmpty()) {
                    return NOT_PLACEABLE;
                }
                list.add(ingredient);
                list2.add(PlacementInfo.ingredientToContents(ingredient));
                list3.add(Optional.of(new SlotInfo(j++)));
                continue;
            }
            list3.add(Optional.empty());
        }
        return new PlacementInfo(list, list2, list3);
    }

    public static PlacementInfo create(List<Ingredient> ingredients) {
        int i = ingredients.size();
        ArrayList<StackedContents.IngredientInfo<ItemOrExact>> list = new ArrayList<StackedContents.IngredientInfo<ItemOrExact>>(i);
        ArrayList<Optional<SlotInfo>> list2 = new ArrayList<Optional<SlotInfo>>(i);
        for (int j = 0; j < i; ++j) {
            Ingredient ingredient = ingredients.get(j);
            if (ingredient.items().isEmpty()) {
                return NOT_PLACEABLE;
            }
            list.add(PlacementInfo.ingredientToContents(ingredient));
            list2.add(Optional.of(new SlotInfo(j)));
        }
        return new PlacementInfo(ingredients, list, list2);
    }

    public List<Optional<SlotInfo>> slotInfo() {
        return this.slotInfo;
    }

    public List<Ingredient> ingredients() {
        return this.ingredients;
    }

    public List<StackedContents.IngredientInfo<ItemOrExact>> unpackedIngredients() {
        return this.unpackedIngredients;
    }

    public boolean isImpossibleToPlace() {
        return this.slotInfo.isEmpty();
    }

    public record SlotInfo(int placerOutputPosition) {
    }
}

