/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.Optional;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public interface SmithingRecipe
extends Recipe<SmithingRecipeInput> {
    @Override
    @Override
    default public RecipeType<SmithingRecipe> getType() {
        return RecipeType.SMITHING;
    }

    @Override
    @Override
    public RecipeSerializer<? extends SmithingRecipe> getSerializer();

    @Override
    @Override
    default public boolean matches(SmithingRecipeInput input, Level world) {
        return Ingredient.testOptionalIngredient(this.templateIngredient(), input.template()) && Ingredient.testOptionalIngredient(this.baseIngredient(), input.base()) && Ingredient.testOptionalIngredient(this.additionIngredient(), input.addition());
    }

    public Optional<Ingredient> templateIngredient();

    public Optional<Ingredient> baseIngredient();

    public Optional<Ingredient> additionIngredient();

    @Override
    @Override
    default public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.SMITHING;
    }
}

